/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.Agent;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.AgentHolder;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.snapshot.SnapshotAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.storage.StorageAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.update.UpdateAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.data.core.DataEntry;
import me.hsgamer.topper.spigot.plugin.lib.topper.data.simple.SimpleDataHolder;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.TopPlayerNumberTemplate;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder.display.ValueDisplay;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.manager.EntryConsumeManager;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.core.ValueProvider;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.core.ValueWrapper;
import org.jetbrains.annotations.Nullable;

public class NumberTopHolder
extends SimpleDataHolder<UUID, Double>
implements AgentHolder<UUID, Double> {
    public static final String GROUP = "topper";
    private final ValueDisplay valueDisplay;
    private final List<Agent> agents;
    private final List<DataEntryAgent<UUID, Double>> entryAgents;
    private final StorageAgent<UUID, Double> storageAgent;
    private final UpdateAgent<UUID, Double> updateAgent;
    private final SnapshotAgent<UUID, Double> snapshotAgent;
    private final Double defaultValue;

    public NumberTopHolder(final TopPlayerNumberTemplate template, final String name, Settings settings) {
        this.defaultValue = settings.defaultValue();
        ArrayList<Agent> agents = new ArrayList<Agent>();
        ArrayList<DataEntryAgent<UUID, Double>> entryAgents = new ArrayList<DataEntryAgent<UUID, Double>>();
        this.valueDisplay = new ValueDisplay(template::getName, settings.displaySettings());
        this.storageAgent = new StorageAgent<UUID, Double>(template.getTopManager().buildStorage(name));
        this.storageAgent.setMaxEntryPerCall(template.getSettings().taskSaveEntryPerTick());
        agents.add(this.storageAgent);
        agents.add(this.storageAgent.getLoadAgent(this));
        agents.add(template.createTaskAgent(this.storageAgent, true, template.getSettings().taskSaveDelay()));
        entryAgents.add(this.storageAgent);
        ValueProvider valueProvider = template.createValueProvider(settings.valueProvider()).orElseGet(() -> {
            template.logWarning("No value provider found for " + name);
            return ValueProvider.empty();
        });
        boolean isAsync = settings.async();
        boolean showErrors = settings.showErrors();
        boolean resetOnError = settings.resetOnError();
        List<String> ignorePermissions = settings.ignorePermissions();
        List<String> resetPermissions = settings.resetPermissions();
        this.updateAgent = new UpdateAgent<UUID, Double>(this, valueProvider);
        if (!ignorePermissions.isEmpty() || !resetPermissions.isEmpty()) {
            this.updateAgent.setFilter(uuid -> {
                if (!template.isOnline((UUID)uuid)) {
                    return UpdateAgent.FilterResult.SKIP;
                }
                if (!resetPermissions.isEmpty() && resetPermissions.stream().anyMatch(s -> template.hasPermission((UUID)uuid, (String)s))) {
                    return UpdateAgent.FilterResult.RESET;
                }
                if (!ignorePermissions.isEmpty() && ignorePermissions.stream().anyMatch(s -> template.hasPermission((UUID)uuid, (String)s))) {
                    return UpdateAgent.FilterResult.SKIP;
                }
                return UpdateAgent.FilterResult.CONTINUE;
            });
        }
        if (resetOnError) {
            this.updateAgent.setErrorHandler((uuid, valueWrapper) -> {
                if (showErrors && valueWrapper.state == ValueWrapper.State.ERROR) {
                    template.logWarning("Error on getting value for " + name + " from " + uuid + " - " + valueWrapper.errorMessage, valueWrapper.throwable);
                }
                return ValueWrapper.handled(this.defaultValue);
            });
        } else if (showErrors) {
            this.updateAgent.setErrorHandler((uuid, valueWrapper) -> {
                if (valueWrapper.state == ValueWrapper.State.ERROR) {
                    template.logWarning("Error on getting value for " + name + " from " + uuid + " - " + valueWrapper.errorMessage, valueWrapper.throwable);
                }
            });
        }
        this.updateAgent.setMaxSkips(template.getSettings().taskUpdateMaxSkips());
        entryAgents.add(this.updateAgent);
        agents.add(template.createTaskAgent(this.updateAgent.getUpdateRunnable(template.getSettings().taskUpdateEntryPerTick()), isAsync, template.getSettings().taskUpdateDelay()));
        agents.add(template.createTaskAgent(this.updateAgent.getSetRunnable(), true, template.getSettings().taskUpdateSetDelay()));
        this.snapshotAgent = SnapshotAgent.create(this);
        boolean reverseOrder = settings.reverse();
        this.snapshotAgent.setComparator(reverseOrder ? Comparator.naturalOrder() : Comparator.reverseOrder());
        this.snapshotAgent.setFilter(entry -> entry.getValue() != null);
        agents.add(this.snapshotAgent);
        agents.add(template.createTaskAgent(this.snapshotAgent, true, 20L));
        entryAgents.add(new DataEntryAgent<UUID, Double>(){

            @Override
            public void onUpdate(DataEntry<UUID, Double> entry, Double oldValue, Double newValue) {
                template.getEntryConsumeManager().consume(new EntryConsumeManager.Context(NumberTopHolder.GROUP, name, entry.getKey(), oldValue, newValue));
            }
        });
        template.modifyAgents(this, agents, entryAgents);
        this.agents = Collections.unmodifiableList(agents);
        this.entryAgents = Collections.unmodifiableList(entryAgents);
    }

    @Override
    @Nullable
    public Double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<Agent> getAgents() {
        return this.agents;
    }

    @Override
    public List<DataEntryAgent<UUID, Double>> getEntryAgents() {
        return this.entryAgents;
    }

    public StorageAgent<UUID, Double> getStorageAgent() {
        return this.storageAgent;
    }

    public UpdateAgent<UUID, Double> getUpdateAgent() {
        return this.updateAgent;
    }

    public SnapshotAgent<UUID, Double> getSnapshotAgent() {
        return this.snapshotAgent;
    }

    public ValueDisplay getValueDisplay() {
        return this.valueDisplay;
    }

    public static interface Settings {
        public Double defaultValue();

        public ValueDisplay.Settings displaySettings();

        public boolean async();

        public boolean showErrors();

        public boolean resetOnError();

        public boolean reverse();

        public List<String> ignorePermissions();

        public List<String> resetPermissions();

        public Map<String, Object> valueProvider();
    }
}

