/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.fabric.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.hsgamer.topper.agent.core.Agent;

public class TaskManager {
    private static final long MILLIS_PER_TICKS = 50L;
    private final List<Task> syncTasks = Collections.synchronizedList(new ArrayList());
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);

    public void onTick() {
        Iterator<Task> taskIterator = this.syncTasks.iterator();
        while (taskIterator.hasNext()) {
            Task task = taskIterator.next();
            if (task.isCancelled()) {
                taskIterator.remove();
                continue;
            }
            task.run();
        }
    }

    public Agent createTaskAgent(final Runnable runnable, boolean async, long delayTicks) {
        final long finalDelayTicks = Math.max(1L, delayTicks);
        if (async) {
            final long delayMillis = finalDelayTicks * 50L;
            return new Agent(){
                private ScheduledFuture<?> scheduledFuture;

                public void start() {
                    this.scheduledFuture = TaskManager.this.scheduler.scheduleAtFixedRate(runnable, delayMillis, delayMillis, TimeUnit.MILLISECONDS);
                }

                public void stop() {
                    if (this.scheduledFuture != null) {
                        this.scheduledFuture.cancel(true);
                    }
                }
            };
        }
        return new Agent(){
            private Task task;

            public void start() {
                this.task = new Task(runnable, finalDelayTicks);
                TaskManager.this.syncTasks.add(this.task);
            }

            public void stop() {
                if (this.task != null) {
                    this.task.cancel();
                }
                this.task = null;
            }
        };
    }

    public void shutdown() {
        this.syncTasks.forEach(Task::cancel);
        this.scheduler.shutdown();
    }

    private static final class Task {
        private final Runnable runnable;
        private final long delayTicks;
        private long nextTime;
        private boolean cancel;

        Task(Runnable runnable, long delayTicks) {
            this.runnable = runnable;
            this.delayTicks = delayTicks;
            this.scheduleTime();
        }

        boolean canRun() {
            return System.currentTimeMillis() >= this.nextTime;
        }

        void scheduleTime() {
            this.nextTime = System.currentTimeMillis() + this.delayTicks * 50L;
        }

        boolean isCancelled() {
            return this.cancel;
        }

        void cancel() {
            this.cancel = true;
        }

        void run() {
            if (this.canRun()) {
                this.runnable.run();
                this.scheduleTime();
            }
        }
    }
}

