/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.hsgamer.topper.spigot.plugin.Permissions;
import me.hsgamer.topper.spigot.plugin.TopperPlugin;
import me.hsgamer.topper.spigot.plugin.config.MessageConfig;
import me.hsgamer.topper.spigot.plugin.lib.core.bukkit.utils.MessageUtils;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder.NumberTopHolder;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder.display.ValueDisplay;
import me.hsgamer.topper.spigot.plugin.template.SpigotTopTemplate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class GetTopListCommand
extends Command {
    private final TopperPlugin instance;

    public GetTopListCommand(TopperPlugin instance) {
        super("gettoplist", "Get Top List", "/gettop <holder> [from_index] [to_index]", Arrays.asList("toplist", "gettop"));
        this.instance = instance;
        this.setPermission(Permissions.TOP.getName());
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (args.length < 1) {
            MessageUtils.sendMessage(sender, "&c" + this.getUsage());
            return false;
        }
        Optional<NumberTopHolder> optional = this.instance.get(SpigotTopTemplate.class).getTopManager().getHolder(args[0]);
        if (!optional.isPresent()) {
            MessageUtils.sendMessage(sender, this.instance.get(MessageConfig.class).getTopHolderNotFound());
            return false;
        }
        NumberTopHolder topHolder = optional.get();
        int fromIndex = 1;
        int toIndex = 10;
        if (args.length == 2) {
            try {
                toIndex = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                MessageUtils.sendMessage(sender, this.instance.get(MessageConfig.class).getNumberRequired());
                return false;
            }
        }
        if (args.length > 2) {
            try {
                fromIndex = Integer.parseInt(args[1]);
                toIndex = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                MessageUtils.sendMessage(sender, this.instance.get(MessageConfig.class).getNumberRequired());
                return false;
            }
        }
        if (fromIndex >= toIndex) {
            MessageUtils.sendMessage(sender, this.instance.get(MessageConfig.class).getIllegalFromToIndex());
            return false;
        }
        ValueDisplay valueDisplay = topHolder.getValueDisplay();
        List<String> topList = IntStream.rangeClosed(fromIndex, toIndex).mapToObj(index -> valueDisplay.getDisplayLine(index, topHolder)).collect(Collectors.toList());
        if (topList.isEmpty()) {
            MessageUtils.sendMessage(sender, this.instance.get(MessageConfig.class).getTopEmpty());
        } else {
            topList.forEach(s -> MessageUtils.sendMessage(sender, s));
        }
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        if (args.length == 1) {
            return this.instance.get(SpigotTopTemplate.class).getTopManager().getHolderNames().stream().filter(name -> args[0].isEmpty() || name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 || args.length == 3) {
            return Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
        }
        return Collections.emptyList();
    }
}

