/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.core.builder;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MassBuilder<I, O> {
    private final ArrayDeque<Function<I, Optional<O>>> elements = new ArrayDeque();

    public MassBuilder<I, O> register(Function<I, Optional<O>> element, boolean addFirst) {
        if (addFirst) {
            this.elements.addFirst(element);
        } else {
            this.elements.addLast(element);
        }
        return this;
    }

    public MassBuilder<I, O> register(Function<I, Optional<O>> element) {
        return this.register(element, false);
    }

    public MassBuilder<I, O> remove(Function<I, Optional<O>> element) {
        this.elements.remove(element);
        return this;
    }

    public MassBuilder<I, O> clear() {
        this.elements.clear();
        return this;
    }

    public Collection<O> buildAll(I input) {
        return this.elements.parallelStream().map(element -> (Optional)element.apply(input)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<O> build(I input) {
        return this.elements.stream().map(element -> (Optional)element.apply(input)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Collection<Function<I, Optional<O>>> getElements() {
        return Collections.unmodifiableCollection(this.elements);
    }
}

