/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.spigot.value.placeholderapi;

import me.clip.placeholderapi.PlaceholderAPI;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.core.ValueProvider;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.core.ValueWrapper;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PlaceholderValueProvider
implements ValueProvider<OfflinePlayer, String> {
    private final String placeholder;
    private final boolean isOnlineOnly;

    public PlaceholderValueProvider(String placeholder, boolean isOnlineOnly) {
        this.placeholder = PlaceholderValueProvider.normalizePlaceholder(placeholder);
        this.isOnlineOnly = isOnlineOnly;
    }

    private static String normalizePlaceholder(String placeholder) {
        return placeholder.isEmpty() || placeholder.startsWith("%") || placeholder.endsWith("%") ? placeholder : "%" + placeholder + "%";
    }

    @Override
    @NotNull
    public ValueWrapper<String> apply(@NotNull OfflinePlayer player) {
        String replaced;
        if (this.isOnlineOnly && !player.isOnline()) {
            return ValueWrapper.notHandled();
        }
        try {
            replaced = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)this.placeholder);
        }
        catch (Exception e) {
            return ValueWrapper.error("Error while parsing the placeholder: " + this.placeholder, e);
        }
        if (this.placeholder.equals(replaced)) {
            return ValueWrapper.notHandled();
        }
        return ValueWrapper.handled(replaced);
    }
}

