/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.Agent;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.core.DataStorage;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder.NumberTopHolder;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.manager.EntryConsumeManager;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.manager.NameProviderManager;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.manager.QueryForwardManager;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.manager.TopManager;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.manager.TopQueryManager;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.core.ValueProvider;
import org.jetbrains.annotations.Nullable;

public abstract class TopPlayerNumberTemplate {
    private final Settings settings;
    private final TopManager topManager;
    private final TopQueryManager topQueryManager;
    private final EntryConsumeManager entryConsumeManager;
    private final QueryForwardManager queryForwardManager;
    private final NameProviderManager nameProviderManager;

    protected TopPlayerNumberTemplate(Settings settings) {
        this.settings = settings;
        this.topManager = new TopManager(this);
        this.topQueryManager = new TopQueryManager(this);
        this.entryConsumeManager = new EntryConsumeManager(this);
        this.queryForwardManager = new QueryForwardManager(this);
        this.nameProviderManager = new NameProviderManager();
    }

    public abstract Function<String, DataStorage<UUID, Double>> getStorageSupplier();

    public abstract Optional<ValueProvider<UUID, Double>> createValueProvider(Map<String, Object> var1);

    public abstract Agent createTaskAgent(Runnable var1, boolean var2, long var3);

    public abstract void logWarning(String var1, @Nullable Throwable var2);

    public String getName(UUID uuid) {
        return this.nameProviderManager.getName(uuid);
    }

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public void modifyAgents(NumberTopHolder holder, List<Agent> agents, List<DataEntryAgent<UUID, Double>> entryAgents) {
    }

    public void enable() {
        this.topManager.enable();
        this.entryConsumeManager.enable();
        this.queryForwardManager.enable();
    }

    public void disable() {
        this.queryForwardManager.disable();
        this.entryConsumeManager.disable();
        this.topManager.disable();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public TopManager getTopManager() {
        return this.topManager;
    }

    public TopQueryManager getTopQueryManager() {
        return this.topQueryManager;
    }

    public EntryConsumeManager getEntryConsumeManager() {
        return this.entryConsumeManager;
    }

    public QueryForwardManager getQueryForwardManager() {
        return this.queryForwardManager;
    }

    public NameProviderManager getNameProviderManager() {
        return this.nameProviderManager;
    }

    public static interface Settings {
        public Map<String, NumberTopHolder.Settings> holders();

        public int taskSaveDelay();

        public int taskSaveEntryPerTick();

        public int taskUpdateEntryPerTick();

        public int taskUpdateDelay();

        public int taskUpdateSetDelay();

        public int taskUpdateMaxSkips();
    }
}

