/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.template;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import me.hsgamer.topper.spigot.plugin.TopperPlugin;
import me.hsgamer.topper.spigot.plugin.lib.core.bukkit.config.BukkitConfig;
import me.hsgamer.topper.spigot.plugin.lib.core.config.Config;
import me.hsgamer.topper.spigot.plugin.lib.core.config.gson.GsonConfig;
import me.hsgamer.topper.spigot.plugin.lib.core.database.client.sql.java.JavaSqlClient;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.core.DataStorage;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.flat.configfile.ConfigFileDataStorage;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.flat.converter.NumberFlatValueConverter;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.flat.converter.UUIDFlatValueConverter;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.flat.core.FlatValueConverter;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.flat.properties.PropertiesDataStorage;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.converter.NumberSqlValueConverter;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.converter.UUIDSqlValueConverter;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.mysql.MySqlDataStorageSupplier;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.sqlite.NewSqliteDataStorageSupplier;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.sqlite.SqliteDataStorageSupplier;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.storagesupplier.StorageSupplierTemplate;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.storagesupplier.storage.DataStorageSupplier;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.storagesupplier.storage.FlatDataStorageSupplier;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.storagesupplier.storage.SqlDataStorageSupplier;
import me.hsgamer.topper.spigot.plugin.template.SpigotDataStorageSupplierSettings;

public class SpigotStorageSupplierTemplate
implements StorageSupplierTemplate {
    private final SpigotDataStorageSupplierSettings dataStorageSupplierSettings;
    private final Map<String, Function<StorageSupplierTemplate.Settings, DataStorageSupplier>> supplierMap;
    private final Function<StorageSupplierTemplate.Settings, DataStorageSupplier> defaultSupplier;

    public SpigotStorageSupplierTemplate(TopperPlugin plugin) {
        this.dataStorageSupplierSettings = new SpigotDataStorageSupplierSettings(plugin);
        this.supplierMap = new HashMap<String, Function<StorageSupplierTemplate.Settings, DataStorageSupplier>>();
        this.defaultSupplier = setting -> new FlatDataStorageSupplier(){
            final /* synthetic */ StorageSupplierTemplate.Settings val$setting;
            {
                this.val$setting = settings;
            }

            @Override
            public <K, V> DataStorage<K, V> getStorage(String name, FlatValueConverter<K> keyConverter, FlatValueConverter<V> valueConverter) {
                return new PropertiesDataStorage<K, V>(this.val$setting.baseFolder(), name, keyConverter, valueConverter);
            }
        };
        this.supplierMap.put("flat", this.defaultSupplier);
        this.supplierMap.put("yaml", setting -> new FlatDataStorageSupplier(){
            final /* synthetic */ StorageSupplierTemplate.Settings val$setting;
            {
                this.val$setting = settings;
            }

            @Override
            public <K, V> DataStorage<K, V> getStorage(String name, FlatValueConverter<K> keyConverter, FlatValueConverter<V> valueConverter) {
                return new ConfigFileDataStorage<K, V>(this.val$setting.baseFolder(), name, keyConverter, valueConverter){

                    @Override
                    protected Config getConfig(File file) {
                        return new BukkitConfig(file);
                    }

                    @Override
                    protected String getConfigName(String name) {
                        return name + ".yml";
                    }
                };
            }
        });
        this.supplierMap.put("json", setting -> new FlatDataStorageSupplier(){
            final /* synthetic */ StorageSupplierTemplate.Settings val$setting;
            {
                this.val$setting = settings;
            }

            @Override
            public <K, V> DataStorage<K, V> getStorage(String name, FlatValueConverter<K> keyConverter, FlatValueConverter<V> valueConverter) {
                return new ConfigFileDataStorage<K, V>(this.val$setting.baseFolder(), name, keyConverter, valueConverter){

                    @Override
                    protected Config getConfig(File file) {
                        return new GsonConfig(file);
                    }

                    @Override
                    protected String getConfigName(String name) {
                        return name + ".json";
                    }
                };
            }
        });
        this.supplierMap.put("sqlite", setting -> {
            SqliteDataStorageSupplier supplier = new SqliteDataStorageSupplier(setting.baseFolder(), setting.databaseSetting(), JavaSqlClient::new);
            return SqlDataStorageSupplier.of(supplier);
        });
        this.supplierMap.put("new-sqlite", setting -> {
            NewSqliteDataStorageSupplier supplier = new NewSqliteDataStorageSupplier(setting.baseFolder(), setting.databaseSetting(), JavaSqlClient::new);
            return SqlDataStorageSupplier.of(supplier);
        });
        this.supplierMap.put("mysql", setting -> {
            MySqlDataStorageSupplier supplier = new MySqlDataStorageSupplier(setting.databaseSetting(), JavaSqlClient::new);
            return SqlDataStorageSupplier.of(supplier);
        });
    }

    @Override
    public DataStorageSupplier getDataStorageSupplier(StorageSupplierTemplate.Settings settings) {
        return this.supplierMap.getOrDefault(settings.storageType().toLowerCase(Locale.ROOT), this.defaultSupplier).apply(settings);
    }

    public Function<String, DataStorage<UUID, Double>> getNumberStorageSupplier() {
        return this.getDataStorageSupplier(this.dataStorageSupplierSettings).getStorageSupplier(new UUIDFlatValueConverter(), new NumberFlatValueConverter<Double>(Number::doubleValue), new UUIDSqlValueConverter("uuid"), new NumberSqlValueConverter<Double>("value", true, Number::doubleValue));
    }
}

