/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.template;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import me.hsgamer.topper.spigot.plugin.TopperPlugin;
import me.hsgamer.topper.spigot.plugin.config.MainConfig;
import me.hsgamer.topper.spigot.plugin.event.GenericEntryUpdateEvent;
import me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.base.Loadable;
import me.hsgamer.topper.spigot.plugin.lib.minelib.scheduler.async.AsyncScheduler;
import me.hsgamer.topper.spigot.plugin.lib.minelib.scheduler.global.GlobalScheduler;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.Agent;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.core.QueryResult;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.forward.QueryForwardContext;
import me.hsgamer.topper.spigot.plugin.lib.topper.spigot.agent.runnable.SpigotRunnableAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.spigot.query.forward.plugin.PluginContext;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.core.DataStorage;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.TopPlayerNumberTemplate;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder.NumberTopHolder;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.core.ValueProvider;
import me.hsgamer.topper.spigot.plugin.manager.ValueProviderManager;
import me.hsgamer.topper.spigot.plugin.template.SpigotStorageSupplierTemplate;
import me.hsgamer.topper.spigot.plugin.template.SpigotTopTemplateSettings;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpigotTopTemplate
extends TopPlayerNumberTemplate
implements Loadable {
    private final TopperPlugin plugin;

    public SpigotTopTemplate(TopperPlugin plugin) {
        super(new SpigotTopTemplateSettings(plugin));
        this.plugin = plugin;
    }

    @Override
    public Function<String, DataStorage<UUID, Double>> getStorageSupplier() {
        return this.plugin.get(SpigotStorageSupplierTemplate.class).getNumberStorageSupplier();
    }

    @Override
    public Optional<ValueProvider<UUID, Double>> createValueProvider(Map<String, Object> settings) {
        return this.plugin.get(ValueProviderManager.class).build(settings);
    }

    @Override
    public Agent createTaskAgent(Runnable runnable, boolean async, long delay) {
        return new SpigotRunnableAgent(runnable, async ? AsyncScheduler.get((Plugin)this.plugin) : GlobalScheduler.get((Plugin)this.plugin), delay);
    }

    @Override
    public void logWarning(String message, @Nullable Throwable throwable) {
        this.plugin.getLogger().log(Level.WARNING, message, throwable);
    }

    @Override
    public void modifyAgents(final NumberTopHolder holder, List<Agent> agents, List<DataEntryAgent<UUID, Double>> entryAgents) {
        agents.add(new Agent(){

            @Override
            public void start() {
                if (SpigotTopTemplate.this.plugin.get(MainConfig.class).isLoadAllOfflinePlayers()) {
                    GlobalScheduler.get((Plugin)SpigotTopTemplate.this.plugin).run(() -> {
                        for (OfflinePlayer player : SpigotTopTemplate.this.plugin.getServer().getOfflinePlayers()) {
                            holder.getOrCreateEntry(player.getUniqueId());
                        }
                    });
                }
            }
        });
    }

    @Override
    public void enable() {
        super.enable();
        this.getEntryConsumeManager().addConsumer(context -> AsyncScheduler.get((Plugin)this.plugin).run(() -> Bukkit.getPluginManager().callEvent((Event)new GenericEntryUpdateEvent(context.group, context.holder, context.uuid, context.oldValue, context.value, true))));
    }

    public void addQueryForwardContext(final Plugin plugin, final String name, final BiFunction<@Nullable UUID, @NotNull String, @NotNull QueryResult> query) {
        this.getQueryForwardManager().addContext(new PluginTopQueryForwardContext(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public BiFunction<@Nullable UUID, @NotNull String, @NotNull QueryResult> getQuery() {
                return query;
            }

            @Override
            public Plugin getPlugin() {
                return plugin;
            }
        });
    }

    private static interface PluginTopQueryForwardContext
    extends QueryForwardContext<UUID>,
    PluginContext {
    }
}

