/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.fabric.template;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import me.hsgamer.hscore.common.CollectionUtils;
import me.hsgamer.topper.agent.update.UpdateAgent;
import me.hsgamer.topper.fabric.TopperFabric;
import me.hsgamer.topper.fabric.template.FabricValueDisplaySettings;
import me.hsgamer.topper.fabric.util.PermissionUtil;
import me.hsgamer.topper.template.topplayernumber.holder.NumberTopHolder;
import me.hsgamer.topper.template.topplayernumber.holder.display.ValueDisplay;

public class FabricTopHolderSettings
implements NumberTopHolder.Settings {
    private final Map<String, Object> map;
    private final FabricValueDisplaySettings valueDisplaySettings;
    private final List<String> ignorePermissions;
    private final List<String> resetPermissions;

    public FabricTopHolderSettings(Map<String, Object> map) {
        this.map = map;
        this.valueDisplaySettings = new FabricValueDisplaySettings(map);
        this.ignorePermissions = CollectionUtils.createStringListFromObject((Object)map.get("ignore-permission"), (boolean)true);
        this.resetPermissions = CollectionUtils.createStringListFromObject((Object)map.get("reset-permission"), (boolean)true);
    }

    public Double defaultValue() {
        return Optional.ofNullable(this.map.get("default-value")).map(Object::toString).map(s -> {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                TopperFabric.LOGGER.warn("Invalid default value: {}. Fallback to null", s, (Object)e);
                return null;
            }
        }).orElse(null);
    }

    public ValueDisplay.Settings displaySettings() {
        return this.valueDisplaySettings;
    }

    public boolean async() {
        return Optional.ofNullable(this.map.get("async")).map(Object::toString).map(String::toLowerCase).map(Boolean::parseBoolean).orElse(false);
    }

    public boolean showErrors() {
        return Optional.ofNullable(this.map.get("show-errors")).map(Object::toString).map(String::toLowerCase).map(Boolean::parseBoolean).orElse(false);
    }

    public boolean resetOnError() {
        return Optional.ofNullable(this.map.get("reset-on-error")).map(Object::toString).map(String::toLowerCase).map(Boolean::parseBoolean).orElse(true);
    }

    public boolean reverse() {
        return Optional.ofNullable(this.map.get("reverse")).map(String::valueOf).map(Boolean::parseBoolean).orElse(false);
    }

    public UpdateAgent.FilterResult filter(UUID uuid) {
        Predicate<String> hasPermission = permission -> PermissionUtil.hasPermission(TopperFabric.getInstance().getServer(), uuid, permission);
        if (!this.resetPermissions.isEmpty() && this.resetPermissions.stream().anyMatch(hasPermission)) {
            return UpdateAgent.FilterResult.RESET;
        }
        if (!this.ignorePermissions.isEmpty() && this.ignorePermissions.stream().anyMatch(hasPermission)) {
            return UpdateAgent.FilterResult.SKIP;
        }
        return UpdateAgent.FilterResult.CONTINUE;
    }

    public Map<String, Object> valueProvider() {
        return this.map;
    }

    public Map<String, Object> map() {
        return this.map;
    }
}

