/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.pb4.placeholders.api.TextParserUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.configurate.ConfigurateConfig;
import me.hsgamer.hscore.config.proxy.ConfigGenerator;
import me.hsgamer.topper.fabric.config.MainConfig;
import me.hsgamer.topper.fabric.config.MessageConfig;
import me.hsgamer.topper.fabric.hook.miniplaceholders.MiniPlaceholdersHook;
import me.hsgamer.topper.fabric.hook.textplaceholderapi.TextPlaceholderAPIHook;
import me.hsgamer.topper.fabric.manager.TaskManager;
import me.hsgamer.topper.fabric.manager.ValueProviderManager;
import me.hsgamer.topper.fabric.template.FabricStorageSupplierTemplate;
import me.hsgamer.topper.fabric.template.FabricTopTemplate;
import me.hsgamer.topper.fabric.util.PermissionUtil;
import me.hsgamer.topper.template.topplayernumber.holder.NumberTopHolder;
import me.hsgamer.topper.template.topplayernumber.holder.display.ValueDisplay;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_3244;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;

public class TopperFabric
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger(TopperFabric.class);
    private static TopperFabric instance;
    private final List<Runnable> disableRunnables = new ArrayList<Runnable>();
    private MinecraftServer server;
    private Path configFolder;
    private Path dataFolder;
    private MainConfig mainConfig;
    private MessageConfig messageConfig;
    private ValueProviderManager valueProviderManager;
    private TaskManager taskManager;
    private FabricStorageSupplierTemplate storageSupplierTemplate;
    private FabricTopTemplate topTemplate;

    public TopperFabric() {
        instance = this;
    }

    public static TopperFabric getInstance() {
        return instance;
    }

    public void onInitialize() {
        this.configFolder = FabricLoader.getInstance().getConfigDir().resolve("topper");
        if (!this.configFolder.toFile().exists()) {
            this.configFolder.toFile().mkdirs();
        }
        this.dataFolder = FabricLoader.getInstance().getGameDir().resolve("topper_data");
        if (!this.dataFolder.toFile().exists()) {
            this.dataFolder.toFile().mkdirs();
        }
        this.mainConfig = (MainConfig)ConfigGenerator.newInstance(MainConfig.class, (Config)new ConfigurateConfig(this.configFolder.resolve("config.json").toFile(), (AbstractConfigurationLoader.Builder)GsonConfigurationLoader.builder().indent(2)));
        this.messageConfig = (MessageConfig)ConfigGenerator.newInstance(MessageConfig.class, (Config)new ConfigurateConfig(this.configFolder.resolve("messages.json").toFile(), (AbstractConfigurationLoader.Builder)GsonConfigurationLoader.builder().indent(2)));
        this.valueProviderManager = new ValueProviderManager(this);
        this.taskManager = new TaskManager();
        this.storageSupplierTemplate = new FabricStorageSupplierTemplate(this);
        this.topTemplate = new FabricTopTemplate(this);
        this.disableRunnables.add(TextPlaceholderAPIHook.addHook(this));
        if (MiniPlaceholdersHook.isAvailable()) {
            this.disableRunnables.add(MiniPlaceholdersHook.addHook(this));
        }
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStop);
        ServerPlayConnectionEvents.JOIN.register(this::onPlayerJoin);
        ServerTickEvents.START_SERVER_TICK.register(this::onServerTick);
        CommandRegistrationCallback.EVENT.register(this::registerCommand);
    }

    private void onServerStart(MinecraftServer server) {
        this.server = server;
        this.topTemplate.enable();
    }

    private void onServerStop(MinecraftServer server) {
        this.disableRunnables.forEach(Runnable::run);
        this.taskManager.shutdown();
        this.topTemplate.disable();
        this.server = null;
    }

    private void onPlayerJoin(class_3244 handler, PacketSender sender, MinecraftServer server) {
        this.topTemplate.getTopManager().create(handler.method_32311().method_5667());
    }

    private void onServerTick(MinecraftServer server) {
        this.taskManager.onTick();
    }

    private void registerCommand(CommandDispatcher<class_2168> commandDispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gettop").requires(source -> source.method_9259(2) || PermissionUtil.hasPermission((class_2172)source, "topper.top"))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"holder", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            this.topTemplate.getTopManager().getHolderNames().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(context -> this.sendTopLines(StringArgumentType.getString((CommandContext)context, (String)"holder"), 1, 10, (CommandContext<class_2168>)context))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"i1", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> this.sendTopLines(StringArgumentType.getString((CommandContext)context, (String)"holder"), 1, IntegerArgumentType.getInteger((CommandContext)context, (String)"i1"), (CommandContext<class_2168>)context))).then(class_2170.method_9244((String)"i2", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> this.sendTopLines(StringArgumentType.getString((CommandContext)context, (String)"holder"), IntegerArgumentType.getInteger((CommandContext)context, (String)"i1"), IntegerArgumentType.getInteger((CommandContext)context, (String)"i2"), (CommandContext<class_2168>)context))))));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reloadtop").requires(source -> source.method_9259(4) || PermissionUtil.hasPermission((class_2172)source, "topper.reload"))).executes(context -> {
            this.topTemplate.getTopManager().disable();
            this.mainConfig.reloadConfig();
            this.messageConfig.reloadConfig();
            this.topTemplate.getTopManager().enable();
            this.sendMessage((class_2168)context.getSource(), this.messageConfig.getSuccess());
            return 1;
        }));
    }

    private int sendTopLines(String holderName, int fromIndex, int toIndex, CommandContext<class_2168> context) {
        Optional optional = this.topTemplate.getTopManager().getHolder(holderName);
        if (optional.isEmpty()) {
            this.sendMessage((class_2168)context.getSource(), this.messageConfig.getTopHolderNotFound());
            return 0;
        }
        NumberTopHolder topHolder = (NumberTopHolder)optional.get();
        if (fromIndex > toIndex) {
            this.sendMessage((class_2168)context.getSource(), this.messageConfig.getIllegalFromToIndex());
            return 0;
        }
        ValueDisplay valueDisplay = topHolder.getValueDisplay();
        List<String> topList = IntStream.rangeClosed(fromIndex, toIndex).mapToObj(index -> valueDisplay.getDisplayLine(index, topHolder)).toList();
        if (topList.isEmpty()) {
            this.sendMessage((class_2168)context.getSource(), this.messageConfig.getTopEmpty());
        } else {
            topList.forEach(s -> this.sendMessage((class_2168)context.getSource(), (String)s));
        }
        return 1;
    }

    private void sendMessage(class_2168 serverCommandSource, String message) {
        String prefix = this.messageConfig.getPrefix();
        serverCommandSource.method_45068(TextParserUtils.formatText((String)(prefix + message)));
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public Path getConfigFolder() {
        return this.configFolder;
    }

    public Path getDataFolder() {
        return this.dataFolder;
    }

    public MainConfig getMainConfig() {
        return this.mainConfig;
    }

    public MessageConfig getMessageConfig() {
        return this.messageConfig;
    }

    public ValueProviderManager getValueProviderManager() {
        return this.valueProviderManager;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public FabricStorageSupplierTemplate getStorageSupplierTemplate() {
        return this.storageSupplierTemplate;
    }

    public FabricTopTemplate getTopTemplate() {
        return this.topTemplate;
    }
}

