/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.fabric.template;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import me.hsgamer.topper.agent.core.Agent;
import me.hsgamer.topper.fabric.TopperFabric;
import me.hsgamer.topper.fabric.util.ProfileUtil;
import me.hsgamer.topper.storage.core.DataStorage;
import me.hsgamer.topper.template.topplayernumber.TopPlayerNumberTemplate;
import me.hsgamer.topper.template.topplayernumber.holder.NumberTopHolder;
import me.hsgamer.topper.value.core.ValueProvider;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FabricTopTemplate
extends TopPlayerNumberTemplate {
    private final TopperFabric mod;

    public FabricTopTemplate(final TopperFabric mod) {
        super(new TopPlayerNumberTemplate.Settings(){

            public Map<String, NumberTopHolder.Settings> holders() {
                return mod.getMainConfig().getHolders();
            }

            public int taskSaveEntryPerTick() {
                return mod.getMainConfig().getTaskSaveEntryPerTick();
            }

            public int taskUpdateEntryPerTick() {
                return mod.getMainConfig().getTaskUpdateEntryPerTick();
            }

            public int taskUpdateMaxSkips() {
                return mod.getMainConfig().getTaskUpdateMaxSkips();
            }
        });
        this.mod = mod;
        this.getNameProviderManager().setDefaultNameProvider(uuid -> {
            class_3222 player = ProfileUtil.getPlayer(mod.getServer(), uuid);
            return player != null ? ProfileUtil.getName(player.method_7334()) : ProfileUtil.getOfflineName(mod.getServer(), uuid);
        });
    }

    public Function<String, DataStorage<UUID, Double>> getStorageSupplier() {
        return this.mod.getStorageSupplierTemplate().getNumberStorageSupplier();
    }

    public Optional<ValueProvider<UUID, Double>> createValueProvider(Map<String, Object> settings) {
        return this.mod.getValueProviderManager().build(settings);
    }

    public Agent createTask(Runnable runnable, NumberTopHolder.TaskType taskType) {
        return switch (taskType) {
            case NumberTopHolder.TaskType.SET -> this.mod.getTaskManager().createTaskAgent(runnable, true, this.mod.getMainConfig().getTaskUpdateSetDelay());
            case NumberTopHolder.TaskType.STORAGE -> this.mod.getTaskManager().createTaskAgent(runnable, true, this.mod.getMainConfig().getTaskSaveDelay());
            default -> this.mod.getTaskManager().createTaskAgent(runnable, true, 20L);
        };
    }

    public Agent createUpdateTask(Runnable runnable, boolean async) {
        return this.mod.getTaskManager().createTaskAgent(runnable, true, this.mod.getMainConfig().getTaskUpdateDelay());
    }

    public void logWarning(String message, @Nullable Throwable throwable) {
        TopperFabric.LOGGER.warn(message, throwable);
    }
}

