package me.hsgamer.topper.fabric.template;

import me.hsgamer.hscore.config.configurate.ConfigurateConfig;
import me.hsgamer.topper.fabric.TopperFabric;
import me.hsgamer.topper.storage.sql.config.SqlDatabaseConfig;
import me.hsgamer.topper.storage.sql.core.SqlDatabaseSetting;
import me.hsgamer.topper.template.storagesupplier.StorageSupplierTemplate;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;

import java.io.File;

public record FabricDataStorageSupplierSettings(TopperFabric mod) implements StorageSupplierTemplate.Settings {
    @Override
    public String storageType() {
        return mod.getMainConfig().getStorageType();
    }

    @Override
    public SqlDatabaseSetting databaseSetting() {
        return new SqlDatabaseConfig("topper", new ConfigurateConfig(
                mod.getConfigFolder().resolve("database.json").toFile(),
                GsonConfigurationLoader.builder().indent(2)
        ));
    }

    @Override
    public File baseFolder() {
        return mod.getDataFolder().toFile();
    }
}
