package me.hsgamer.topper.fabric.util;

import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2172;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import java.util.UUID;

public interface PermissionUtil {
    static boolean hasOp(MinecraftServer server, UUID uuid) {
        class_3222 player = server.method_3760().method_14602(uuid);
        if (player == null) return false;
        return player.method_5691() > 0;
    }

    static boolean hasPermission(class_2172 commandSource, String permission) {
        if (!FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0")) return false;
        return Permissions.check(commandSource, permission);
    }

    static boolean hasPermission(class_1297 entity, String permission) {
        if (!FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0")) return false;
        return Permissions.check(entity, permission);
    }

    static boolean hasPermission(MinecraftServer server, UUID uuid, String permission) {
        class_3222 player = ProfileUtil.getPlayer(server, uuid);
        if (player == null) return false;
        return hasPermission(player, permission);
    }
}
