/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.fabric.template;

import java.util.Locale;
import me.hsgamer.hscore.database.client.sql.java.JavaSqlClient;
import me.hsgamer.topper.fabric.TopperFabric;
import me.hsgamer.topper.storage.core.DataStorage;
import me.hsgamer.topper.storage.flat.core.FlatValueConverter;
import me.hsgamer.topper.storage.flat.properties.PropertiesDataStorage;
import me.hsgamer.topper.storage.sql.core.SqlValueConverter;
import me.hsgamer.topper.storage.sql.mysql.MySqlDataStorageSupplier;
import me.hsgamer.topper.storage.sql.sqlite.NewSqliteDataStorageSupplier;
import me.hsgamer.topper.template.storagesupplier.StorageSupplierTemplate;
import me.hsgamer.topper.template.storagesupplier.storage.DataStorageSupplier;

public class FabricStorageSupplierTemplate
implements StorageSupplierTemplate {
    public DataStorageSupplier getDataStorageSupplier(final StorageSupplierTemplate.Settings settings) {
        String type = settings.storageType();
        if (type.toLowerCase(Locale.ROOT).equals("mysql")) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                final MySqlDataStorageSupplier mySqlDataStorageSupplier = new MySqlDataStorageSupplier(settings.databaseSetting(), JavaSqlClient::new);
                return new DataStorageSupplier(){

                    public <K, V> DataStorage<K, V> getStorage(String name, FlatValueConverter<K> keyConverter, FlatValueConverter<V> valueConverter, SqlValueConverter<K> sqlKeyConverter, SqlValueConverter<V> sqlValueConverter) {
                        return mySqlDataStorageSupplier.getStorage(name, sqlKeyConverter, sqlValueConverter);
                    }
                };
            }
            catch (ClassNotFoundException ex) {
                TopperFabric.LOGGER.warn("You set your database to be MYSQL but no driver is found.\nYou must install a driver to use this database type.\nRecommended link: https://modrinth.com/plugin/mysql-jdbc\n");
            }
        } else if (type.toLowerCase(Locale.ROOT).equals("sqlite")) {
            try {
                Class.forName("org.sqlite.JDBC");
                final NewSqliteDataStorageSupplier newSqliteDataStorageSupplier = new NewSqliteDataStorageSupplier(settings.baseFolder(), settings.databaseSetting(), JavaSqlClient::new);
                return new DataStorageSupplier(){

                    public <K, V> DataStorage<K, V> getStorage(String name, FlatValueConverter<K> keyConverter, FlatValueConverter<V> valueConverter, SqlValueConverter<K> sqlKeyConverter, SqlValueConverter<V> sqlValueConverter) {
                        return newSqliteDataStorageSupplier.getStorage(name, sqlKeyConverter, sqlValueConverter);
                    }
                };
            }
            catch (ClassNotFoundException ex) {
                TopperFabric.LOGGER.warn("You set your database to be SQLITE but no driver is found.\nYou must install a driver to use this database type.\nRecommended link: https://modrinth.com/plugin/sqlite-jdbc\n");
            }
        }
        return new DataStorageSupplier(){

            public <K, V> DataStorage<K, V> getStorage(String name, FlatValueConverter<K> keyConverter, FlatValueConverter<V> valueConverter, SqlValueConverter<K> sqlKeyConverter, SqlValueConverter<V> sqlValueConverter) {
                return new PropertiesDataStorage(settings.baseFolder(), name, keyConverter, valueConverter);
            }
        };
    }
}

