/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.config;

import java.util.Collections;
import java.util.Map;
import me.hsgamer.topper.spigot.plugin.config.converter.HolderMapConverter;
import me.hsgamer.topper.spigot.plugin.lib.core.config.Config;
import me.hsgamer.topper.spigot.plugin.lib.core.config.annotation.Comment;
import me.hsgamer.topper.spigot.plugin.lib.core.config.annotation.ConfigPath;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder.NumberTopHolder;

public interface MainConfig {
    @ConfigPath(value={"holders"}, converter=HolderMapConverter.class, priority=1)
    @Comment(value={"The settings for the Top Holders", "Check the wiki for more information on how to setup Top Holder using Value Provider", "https://topper-mc.github.io/Wiki/topper/provider/"})
    default public Map<String, NumberTopHolder.Settings> getHolders() {
        return Collections.emptyMap();
    }

    @ConfigPath(value={"load-all-offline-players"}, priority=3)
    @Comment(value={"Should the plugin load all offline players when the server starts"})
    default public boolean isLoadAllOfflinePlayers() {
        return false;
    }

    @ConfigPath(value={"task", "save", "entry-per-tick"}, priority=4)
    @Comment(value={"How many entries should be saved per tick"})
    default public int getTaskSaveEntryPerTick() {
        return 10;
    }

    @ConfigPath(value={"task", "save", "delay"}, priority=4)
    @Comment(value={"How many ticks should the plugin wait before saving the leaderboard"})
    default public int getTaskSaveDelay() {
        return 0;
    }

    @ConfigPath(value={"task", "update", "entry-per-tick"}, priority=5)
    @Comment(value={"How many entries should be updated per tick"})
    default public int getTaskUpdateEntryPerTick() {
        return 10;
    }

    @ConfigPath(value={"task", "update", "delay"}, priority=5)
    @Comment(value={"How many ticks should the plugin wait before updating the leaderboard"})
    default public int getTaskUpdateDelay() {
        return 0;
    }

    @ConfigPath(value={"task", "update", "max-skips"}, priority=5)
    @Comment(value={"How many times should the plugin skip updating the value for the entry if it fails to update", "This is useful to let the plugin prioritize other active entries"})
    default public int getTaskUpdateMaxSkips() {
        return 1;
    }

    @ConfigPath(value={"task", "update", "set-delay"}, priority=5)
    @Comment(value={"How many ticks should the plugin wait before applying the updated value to the entry", "Since the holder is updated partially, this is useful to prevent the plugin from applying the value too early", "and to allow the plugin to apply the value in larger batches, creating the illusion of a single update"})
    default public int getTaskUpdateSetDelay() {
        return 0;
    }

    @ConfigPath(value={"storage-type"})
    @Comment(value={"The type of storage the plugin will use to store the value", "Available: FLAT, YAML, JSON, SQLITE, NEW-SQLITE, MYSQL"})
    default public String getStorageType() {
        return "flat";
    }

    public void reloadConfig();

    public Config getConfig();
}

