/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.hook.paper;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;

public class PaperNameCache
implements Function<UUID, String> {
    private static MethodHandle createProfileMethod;
    private static MethodHandle completeFromCacheMethod;
    private static MethodHandle getNameMethod;

    public static boolean isAvailable() {
        return createProfileMethod != null && completeFromCacheMethod != null && getNameMethod != null;
    }

    @Override
    public String apply(UUID uuid) {
        if (!PaperNameCache.isAvailable()) {
            return null;
        }
        if (Bukkit.getPlayer((UUID)uuid) != null) {
            return null;
        }
        try {
            Object profile = createProfileMethod.invoke(uuid);
            completeFromCacheMethod.invoke(profile);
            String name = getNameMethod.invoke(profile);
            return name != null && !name.isEmpty() ? name : null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        try {
            MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
            Class<?> profileClass = Class.forName("com.destroystokyo.paper.profile.PlayerProfile");
            completeFromCacheMethod = publicLookup.findVirtual(profileClass, "completeFromCache", MethodType.methodType(Boolean.TYPE));
            getNameMethod = publicLookup.findVirtual(profileClass, "getName", MethodType.methodType(String.class));
            createProfileMethod = publicLookup.findStatic(Bukkit.class, "createProfile", MethodType.methodType(profileClass, UUID.class));
        }
        catch (Throwable e) {
            createProfileMethod = null;
            completeFromCacheMethod = null;
            getNameMethod = null;
        }
    }
}

