/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.core.config.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.hsgamer.topper.spigot.plugin.lib.core.config.Config;
import me.hsgamer.topper.spigot.plugin.lib.core.config.PathString;
import me.hsgamer.topper.spigot.plugin.lib.core.gson.GsonUtils;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.common.LogLevel;

public class GsonConfig
implements Config {
    private final Gson gson;
    private final File file;
    private JsonObject root = new JsonObject();

    public GsonConfig(File file, Gson gson) {
        this.file = file;
        this.gson = gson;
    }

    public GsonConfig(File file) {
        this(file, new Gson());
    }

    private static Map<String[], Object> getValues(JsonObject object, boolean deep) {
        HashMap<String[], Object> values = new HashMap<String[], Object>();
        for (Map.Entry entry : object.entrySet()) {
            String[] key = PathString.asArray((String)entry.getKey());
            JsonElement element = (JsonElement)entry.getValue();
            values.put(key, element);
            if (!element.isJsonObject() || !deep) continue;
            Map<String[], Object> subValues = GsonConfig.getValues(element.getAsJsonObject(), true);
            for (Map.Entry<String[], Object> subEntry : subValues.entrySet()) {
                values.put(PathString.concat(key, subEntry.getKey()), subEntry.getValue());
            }
        }
        return values;
    }

    public JsonObject getOriginal() {
        return this.root;
    }

    private Optional<JsonObject> getJsonObject(boolean createIfNotFound, String ... path) {
        JsonObject currentObject = this.root;
        if (path.length == 0) {
            return Optional.of(currentObject);
        }
        for (int i = 0; i < path.length; ++i) {
            JsonNull element;
            String key = path[i];
            if (i == path.length - 1) {
                return Optional.of(currentObject);
            }
            Object object = element = currentObject.has(key) ? currentObject.get(key) : JsonNull.INSTANCE;
            if (element.isJsonObject()) {
                currentObject = element.getAsJsonObject();
                continue;
            }
            if (createIfNotFound) {
                JsonObject newObject = new JsonObject();
                currentObject.add(key, (JsonElement)newObject);
                currentObject = newObject;
                continue;
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public Object get(Object def, String ... path) {
        if (path.length == 0) {
            return this.root;
        }
        return this.getJsonObject(false, path).map(object -> {
            String lastPath = path[path.length - 1];
            if (object.has(lastPath)) {
                return object.get(lastPath);
            }
            return null;
        }).orElseGet(() -> {
            if (def == null) {
                return null;
            }
            if (def instanceof JsonElement) {
                return def;
            }
            return this.gson.toJsonTree(def);
        });
    }

    @Override
    public void set(Object value, String ... path) {
        JsonElement element;
        JsonElement jsonElement = element = value instanceof JsonElement ? (JsonElement)value : this.gson.toJsonTree(value);
        if (path.length == 0) {
            if (element.isJsonObject()) {
                this.root = element.getAsJsonObject();
            }
            return;
        }
        this.getJsonObject(true, path).ifPresent(object -> {
            String lastPath = path[path.length - 1];
            if (element.isJsonNull()) {
                object.remove(lastPath);
            } else {
                object.add(lastPath, element);
            }
        });
    }

    @Override
    public void clear() {
        this.root = new JsonObject();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public Map<String[], Object> getValues(boolean deep, String ... path) {
        if (path.length == 0) {
            return GsonConfig.getValues(this.root, deep);
        }
        return this.getJsonObject(false, path).map(object -> GsonConfig.getValues(object, deep)).orElse(Collections.emptyMap());
    }

    @Override
    public void setup() {
        if (!this.file.exists()) {
            File parentFile = this.file.getAbsoluteFile().getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.log(LogLevel.WARN, "Something wrong when creating " + this.file.getName(), e);
            }
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(this.file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            JsonElement jsonElement = GsonUtils.parse(reader);
            if (jsonElement.isJsonObject()) {
                this.root = jsonElement.getAsJsonObject();
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.WARN, "Something wrong when loading " + this.file.getName(), e);
        }
    }

    @Override
    public void save() {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
             JsonWriter jsonWriter = this.gson.newJsonWriter((Writer)writer);){
            Streams.write((JsonElement)this.root, (JsonWriter)jsonWriter);
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.WARN, "Something wrong when saving " + this.file.getName(), e);
        }
    }

    @Override
    public void reload() {
        this.root = new JsonObject();
        this.setup();
    }

    @Override
    public Object normalize(Object object) {
        if (!this.isNormalizable(object)) {
            return object;
        }
        return GsonUtils.normalize((JsonElement)object, false);
    }

    @Override
    public boolean isNormalizable(Object object) {
        return object instanceof JsonElement;
    }
}

