/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.core.database.client.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.common.LogLevel;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.common.Logger;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.provider.LoggerProvider;
import org.intellij.lang.annotations.Language;

public class BatchBuilder {
    private static final Logger LOGGER = LoggerProvider.getLogger(BatchBuilder.class);
    private final Connection connection;
    @Language(value="SQL")
    private final String statement;
    private final List<Object[]> values = new ArrayList<Object[]>();

    private BatchBuilder(Connection connection, @Language(value="SQL") String statement) {
        this.connection = connection;
        this.statement = statement;
    }

    public static BatchBuilder create(Connection connection, @Language(value="SQL") String statement) {
        return new BatchBuilder(connection, statement);
    }

    public BatchBuilder addValues(Object ... values) {
        this.values.add(values);
        return this;
    }

    public BatchBuilder addValues(List<Object> values) {
        return this.addValues(values.toArray());
    }

    public int[] execute() throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(this.statement);){
            for (Object[] value : this.values) {
                for (int i = 0; i < value.length; ++i) {
                    preparedStatement.setObject(i + 1, value[i]);
                }
                preparedStatement.addBatch();
            }
            Object object = preparedStatement.executeBatch();
            return object;
        }
    }

    public int[] executeSafe() {
        try {
            return this.execute();
        }
        catch (SQLException e) {
            LOGGER.log(LogLevel.WARN, e);
            return new int[0];
        }
    }
}

