/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.base;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.base.Loadable;
import org.bukkit.plugin.java.JavaPlugin;

public class BasePlugin
extends JavaPlugin
implements Loadable {
    private final List<Object> components = this.getComponents();
    private final Map<Class<?>, List<Object>> lookupMap = new ConcurrentHashMap();

    protected List<Object> getComponents() {
        return Collections.emptyList();
    }

    private List<Object> getComponents(Class<?> type) {
        return this.lookupMap.computeIfAbsent(type, t -> this.components.stream().filter(t::isInstance).map(t::cast).collect(Collectors.toList()));
    }

    public final <T> List<T> getAll(Class<T> type) {
        return this.getComponents(type);
    }

    public final <T> T get(Class<T> type) {
        List<Object> components = this.getComponents(type);
        if (components.isEmpty()) {
            throw new IllegalArgumentException("No component of type " + type.getName() + " found");
        }
        return type.cast(components.get(0));
    }

    public final <T> void call(Class<T> type, Consumer<T> consumer, boolean reverse) {
        int step;
        int index;
        List<T> components = this.getAll(type);
        if (components.isEmpty()) {
            return;
        }
        int size = components.size();
        if (reverse) {
            index = size - 1;
            step = -1;
        } else {
            index = 0;
            step = 1;
        }
        while (index >= 0 && index < size) {
            T component = components.get(index);
            consumer.accept(component);
            index += step;
        }
    }

    public final <T> void call(Class<T> type, Consumer<T> consumer) {
        this.call(type, consumer, false);
    }

    public final void onLoad() {
        this.call(Loadable.class, Loadable::load);
        this.load();
    }

    public final void onEnable() {
        this.call(Loadable.class, Loadable::enable);
        this.enable();
    }

    public final void onDisable() {
        this.call(Loadable.class, Loadable::disable, true);
        this.disable();
        this.lookupMap.clear();
    }
}

