/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.query.simple;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.core.Query;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.core.QueryResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleQuery<A, C extends Context>
implements Query<A> {
    private final Map<String, BiFunction<@Nullable A, @NotNull C, @Nullable String>> actions = new HashMap<String, BiFunction<A, C, String>>();

    protected abstract Optional<C> getContext(@NotNull String var1);

    protected void registerAction(String name, BiFunction<@Nullable A, @NotNull C, @Nullable String> action) {
        this.actions.put(name, action);
    }

    protected void registerActorAction(String name, BiFunction<@NotNull A, @NotNull C, @Nullable String> function) {
        this.registerAction(name, (actor, context) -> {
            if (actor == null) {
                return null;
            }
            return (String)function.apply(actor, context);
        });
    }

    @Override
    @NotNull
    public QueryResult apply(@Nullable A actor, @NotNull String query) {
        Optional<C> optionalContext = this.getContext(query);
        if (!optionalContext.isPresent()) {
            return QueryResult.notHandled();
        }
        Context context = (Context)optionalContext.get();
        String actionName = context.getActionName();
        BiFunction<@Nullable A, @NotNull C, @Nullable String> action = this.actions.get(actionName);
        if (action == null) {
            return QueryResult.notHandled();
        }
        return QueryResult.handled(action.apply(actor, context));
    }

    public static interface Context {
        @NotNull
        public String getActionName();
    }
}

