/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.converter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.function.Function;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.core.SqlValueConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleSqlValueConverter<T>
implements SqlValueConverter<T> {
    private final Function<@NotNull T, @NotNull String> toStringConverter;
    private final Function<@NotNull String, @Nullable T> fromStringConverter;
    private final String valueName;
    private final String sqlType;
    private final boolean isStringNationalized;

    public SimpleSqlValueConverter(Function<@NotNull T, @NotNull String> toStringConverter, Function<@NotNull String, @Nullable T> fromStringConverter, String valueName, String sqlType, boolean isStringNationalized) {
        this.toStringConverter = toStringConverter;
        this.fromStringConverter = fromStringConverter;
        this.valueName = valueName;
        this.sqlType = sqlType;
        this.isStringNationalized = isStringNationalized;
    }

    public SimpleSqlValueConverter(Function<@NotNull T, @NotNull String> toStringConverter, Function<@NotNull String, @Nullable T> fromStringConverter, String valueName, String sqlType) {
        this(toStringConverter, fromStringConverter, valueName, sqlType, sqlType.toUpperCase(Locale.ROOT).startsWith("N"));
    }

    public SimpleSqlValueConverter(Function<@NotNull T, @NotNull String> toStringConverter, Function<@NotNull String, @Nullable T> fromStringConverter, String valueName, boolean isStringNationalized, int stringMaxLength) {
        this(toStringConverter, fromStringConverter, valueName, (isStringNationalized ? "N" : "") + "VARCHAR(" + stringMaxLength + ")", isStringNationalized);
    }

    @Override
    public String[] getSqlColumns() {
        return new String[]{this.valueName};
    }

    @Override
    public String[] getSqlColumnDefinitions() {
        return new String[]{this.sqlType + " NOT NULL"};
    }

    @Override
    public Object[] toSqlValues(@NotNull T value) {
        return new Object[]{this.toStringConverter.apply(value)};
    }

    @Override
    @Nullable
    public T fromSqlResultSet(@NotNull ResultSet resultSet) throws SQLException {
        String value = this.isStringNationalized ? resultSet.getNString(this.valueName) : resultSet.getString(this.valueName);
        return value == null ? null : (T)this.fromStringConverter.apply(value);
    }
}

