/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;

public class NameProviderManager {
    private final List<Function<UUID, String>> nameProviders = new ArrayList<Function<UUID, String>>();
    private Function<UUID, String> defaultNameProvider = null;

    public Runnable addNameProvider(Function<UUID, String> nameProvider) {
        this.nameProviders.add(nameProvider);
        return () -> this.nameProviders.remove(nameProvider);
    }

    public void setDefaultNameProvider(Function<UUID, String> defaultNameProvider) {
        this.defaultNameProvider = defaultNameProvider;
    }

    public String getName(UUID uuid) {
        for (Function<UUID, String> nameProvider : this.nameProviders) {
            String name = nameProvider.apply(uuid);
            if (name == null) continue;
            return name;
        }
        if (this.defaultNameProvider != null) {
            return this.defaultNameProvider.apply(uuid);
        }
        return null;
    }

    public void clear() {
        this.nameProviders.clear();
        this.defaultNameProvider = null;
    }
}

