/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.template;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import me.hsgamer.topper.spigot.plugin.lib.core.common.CollectionUtils;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.update.UpdateAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder.NumberTopHolder;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder.display.ValueDisplay;
import me.hsgamer.topper.spigot.plugin.template.SpigotValueDisplaySettings;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotTopHolderSettings
implements NumberTopHolder.Settings {
    private final Map<String, Object> map;
    private final SpigotValueDisplaySettings valueDisplaySettings;
    private final List<String> ignorePermissions;
    private final List<String> resetPermissions;

    public SpigotTopHolderSettings(Map<String, Object> map) {
        this.map = map;
        this.valueDisplaySettings = new SpigotValueDisplaySettings(map);
        this.ignorePermissions = CollectionUtils.createStringListFromObject(map.get("ignore-permission"), true);
        this.resetPermissions = CollectionUtils.createStringListFromObject(map.get("reset-permission"), true);
    }

    @Override
    public Double defaultValue() {
        return Optional.ofNullable(this.map.get("default-value")).map(Object::toString).map(s -> {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                JavaPlugin.getProvidingPlugin(this.getClass()).getLogger().log(Level.WARNING, "Invalid default value: " + s + ". Fallback to null", e);
                return null;
            }
        }).orElse(null);
    }

    @Override
    public ValueDisplay.Settings displaySettings() {
        return this.valueDisplaySettings;
    }

    @Override
    public boolean async() {
        return Optional.ofNullable(this.map.get("async")).map(Object::toString).map(String::toLowerCase).map(Boolean::parseBoolean).orElse(false);
    }

    @Override
    public boolean showErrors() {
        return Optional.ofNullable(this.map.get("show-errors")).map(Object::toString).map(String::toLowerCase).map(Boolean::parseBoolean).orElse(false);
    }

    @Override
    public boolean resetOnError() {
        return Optional.ofNullable(this.map.get("reset-on-error")).map(Object::toString).map(String::toLowerCase).map(Boolean::parseBoolean).orElse(true);
    }

    @Override
    public boolean reverse() {
        return Optional.ofNullable(this.map.get("reverse")).map(String::valueOf).map(Boolean::parseBoolean).orElse(false);
    }

    @Override
    public UpdateAgent.FilterResult filter(UUID uuid) {
        if (this.ignorePermissions.isEmpty() && this.resetPermissions.isEmpty()) {
            return UpdateAgent.FilterResult.CONTINUE;
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return UpdateAgent.FilterResult.SKIP;
        }
        if (!this.resetPermissions.isEmpty()) {
            if (this.resetPermissions.stream().anyMatch(arg_0 -> ((Player)player).hasPermission(arg_0))) {
                return UpdateAgent.FilterResult.RESET;
            }
        }
        if (!this.ignorePermissions.isEmpty()) {
            if (this.ignorePermissions.stream().anyMatch(arg_0 -> ((Player)player).hasPermission(arg_0))) {
                return UpdateAgent.FilterResult.SKIP;
            }
        }
        return UpdateAgent.FilterResult.CONTINUE;
    }

    @Override
    public Map<String, Object> valueProvider() {
        return this.map;
    }

    public Map<String, Object> map() {
        return this.map;
    }
}

