/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class DogCuddleListener
implements Listener {
    private final JavaPlugin plugin;
    private final Map<UUID, CuddleSession> activeCuddles = new HashMap<UUID, CuddleSession>();

    public DogCuddleListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        this.checkCuddleConditions(player);
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        this.checkCuddleConditions(player);
    }

    private void checkCuddleConditions(Player player) {
        UUID playerId = player.getUniqueId();
        boolean isSneaking = player.isSneaking();
        Wolf nearbyWolf = this.findNearbyTamedWolf(player);
        if (isSneaking && nearbyWolf != null && nearbyWolf.isSitting()) {
            if (!this.activeCuddles.containsKey(playerId)) {
                this.startCuddling(player, nearbyWolf);
            }
        } else if (this.activeCuddles.containsKey(playerId)) {
            this.stopCuddling(player);
        }
    }

    private Wolf findNearbyTamedWolf(Player player) {
        Location playerLoc = player.getLocation();
        for (Entity entity : player.getNearbyEntities(1.5, 1.5, 1.5)) {
            double distance;
            Wolf wolf;
            if (!(entity instanceof Wolf) || !(wolf = (Wolf)entity).isTamed() || wolf.getOwner() == null || !wolf.getOwner().getUniqueId().equals(player.getUniqueId()) || !((distance = playerLoc.distance(wolf.getLocation())) <= 1.0)) continue;
            return wolf;
        }
        return null;
    }

    private void startCuddling(Player player, Wolf wolf) {
        UUID playerId = player.getUniqueId();
        String dogName = this.getDogName(wolf);
        CuddleSession session = new CuddleSession(wolf, dogName);
        this.activeCuddles.put(playerId, session);
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            double maxHealth;
            Player currentPlayer = Bukkit.getPlayer((UUID)playerId);
            if (currentPlayer == null || !currentPlayer.isOnline()) {
                this.stopCuddling(playerId);
                return;
            }
            if (!currentPlayer.isSneaking() || this.findNearbyTamedWolf(currentPlayer) != wolf || !wolf.isSitting()) {
                this.stopCuddling(currentPlayer);
                return;
            }
            double currentHealth = currentPlayer.getHealth();
            if (currentHealth < (maxHealth = currentPlayer.getAttribute(Attribute.MAX_HEALTH).getValue())) {
                double newHealth = Math.min(maxHealth, currentHealth + 2.0);
                currentPlayer.setHealth(newHealth);
            }
            TextComponent message = Component.text((String)("Cuddling " + dogName));
            currentPlayer.sendActionBar((Component)message);
            this.spawnHeartParticles(currentPlayer, wolf);
        }, 0L, 20L);
        session.setTask(task);
    }

    private void stopCuddling(Player player) {
        this.stopCuddling(player.getUniqueId());
    }

    private void stopCuddling(UUID playerId) {
        CuddleSession session = this.activeCuddles.remove(playerId);
        if (session != null && session.getTask() != null) {
            session.getTask().cancel();
        }
    }

    private String getDogName(Wolf wolf) {
        Component customName = wolf.customName();
        if (customName != null) {
            return PlainTextComponentSerializer.plainText().serialize(customName);
        }
        return "Wolf";
    }

    private void spawnHeartParticles(Player player, Wolf wolf) {
        Location playerLoc = player.getLocation().add(0.0, 1.0, 0.0);
        Location wolfLoc = wolf.getLocation().add(0.0, 0.5, 0.0);
        player.getWorld().spawnParticle(Particle.HEART, playerLoc, 3, 0.3, 0.3, 0.3, 0.0);
        wolf.getWorld().spawnParticle(Particle.HEART, wolfLoc, 2, 0.2, 0.2, 0.2, 0.0);
    }

    public void cleanup() {
        for (CuddleSession session : this.activeCuddles.values()) {
            if (session.getTask() == null) continue;
            session.getTask().cancel();
        }
        this.activeCuddles.clear();
    }

    private static class CuddleSession {
        private BukkitTask task;

        public CuddleSession(Wolf wolf, String dogName) {
        }

        public BukkitTask getTask() {
            return this.task;
        }

        public void setTask(BukkitTask task) {
            this.task = task;
        }
    }
}

