/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allaboutengie.item;

import com.google.common.collect.Iterables;
import java.util.Map;
import net.mcreator.allaboutengie.init.AllaboutengieModItems;
import net.mcreator.allaboutengie.procedures.AEBootsProcedure;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class AngryEngiesItem
extends ArmorItem {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(100, Map.of(ArmorType.BOOTS, 100, ArmorType.LEGGINGS, 100, ArmorType.CHESTPLATE, 100, ArmorType.HELMET, 100, ArmorType.BODY, 100), 10, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_iron")), 3.0f, 0.0f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"allaboutengie:angry_engies_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"allaboutengie:angry_engies")));

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"allaboutengie:textures/models/armor/angryengi__layer_1.png");
            }
        }, new Item[]{(Item)AllaboutengieModItems.ANGRY_ENGIES_HELMET.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"allaboutengie:textures/models/armor/angryengi__layer_1.png");
            }
        }, new Item[]{(Item)AllaboutengieModItems.ANGRY_ENGIES_CHESTPLATE.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"allaboutengie:textures/models/armor/angryengi__layer_2.png");
            }
        }, new Item[]{(Item)AllaboutengieModItems.ANGRY_ENGIES_LEGGINGS.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"allaboutengie:textures/models/armor/angryengi__layer_1.png");
            }
        }, new Item[]{(Item)AllaboutengieModItems.ANGRY_ENGIES_BOOTS.get()});
    }

    private AngryEngiesItem(ArmorType type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends AngryEngiesItem {
        public Boots(Item.Properties properties) {
            super(ArmorType.BOOTS, properties);
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                AEBootsProcedure.execute(entity);
            }
        }
    }

    public static class Leggings
    extends AngryEngiesItem {
        public Leggings(Item.Properties properties) {
            super(ArmorType.LEGGINGS, properties);
        }
    }

    public static class Chestplate
    extends AngryEngiesItem {
        public Chestplate(Item.Properties properties) {
            super(ArmorType.CHESTPLATE, properties);
        }
    }

    public static class Helmet
    extends AngryEngiesItem {
        public Helmet(Item.Properties properties) {
            super(ArmorType.HELMET, properties);
        }
    }
}

