/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allaboutengie.item;

import net.mcreator.allaboutengie.init.AllaboutengieModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class EngiesItem
extends ArmorItem {
    public EngiesItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 50;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{50, 50, 50, 50})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 10;
            }

            public SoundEvent getEquipSound() {
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("item.armor.equip_leather"));
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AllaboutengieModItems.ENGIE_GEM.get())});
            }

            public String getName() {
                return "engies";
            }

            public float getToughness() {
                return 2.0f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends EngiesItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/engie__layer_1.png";
        }
    }

    public static class Leggings
    extends EngiesItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/engie__layer_2.png";
        }
    }

    public static class Chestplate
    extends EngiesItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/engie__layer_1.png";
        }
    }

    public static class Helmet
    extends EngiesItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/engie__layer_1.png";
        }
    }
}

