/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allaboutengie.item;

import com.google.common.collect.Iterables;
import net.mcreator.allaboutengie.init.AllaboutengieModItems;
import net.mcreator.allaboutengie.procedures.BAEBootsProcedure;
import net.mcreator.allaboutengie.procedures.BAEChestplateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class AntimatterBiblicallyAccurateEngiesItem
extends ArmorItem {
    public AntimatterBiblicallyAccurateEngiesItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 725;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{725, 725, 725, 725})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 22;
            }

            public SoundEvent getEquipSound() {
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("item.armor.equip_netherite"));
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AllaboutengieModItems.ANTIMATTER_BIBLICALLY_ACCURATE_ENGIE_ESSENCE.get())});
            }

            public String getName() {
                return "antimatter_biblically_accurate_engies";
            }

            public float getToughness() {
                return 40.0f;
            }

            public float getKnockbackResistance() {
                return 1.5f;
            }
        }, type, properties);
    }

    public static class Boots
    extends AntimatterBiblicallyAccurateEngiesItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/antimatterbiblicallyaccurateengie_layer_1.png";
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                BAEBootsProcedure.execute(entity);
            }
        }
    }

    public static class Leggings
    extends AntimatterBiblicallyAccurateEngiesItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/antimatterbiblicallyaccurateengie_layer_2.png";
        }
    }

    public static class Chestplate
    extends AntimatterBiblicallyAccurateEngiesItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/antimatterbiblicallyaccurateengie_layer_1.png";
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                BAEChestplateProcedure.execute(entity);
            }
        }
    }

    public static class Helmet
    extends AntimatterBiblicallyAccurateEngiesItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/antimatterbiblicallyaccurateengie_layer_1.png";
        }
    }
}

