/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allaboutengie.item;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public abstract class CodeRedeemersItem
extends ArmorItem {
    public CodeRedeemersItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 50;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{50, 50, 50, 50})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 12;
            }

            public SoundEvent getEquipSound() {
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("item.armor.equip_netherite"));
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of();
            }

            public String getName() {
                return "code_redeemers";
            }

            public float getToughness() {
                return 2.5f;
            }

            public float getKnockbackResistance() {
                return 0.2f;
            }
        }, type, properties);
    }

    public static class Boots
    extends CodeRedeemersItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.translatable((String)"item.allaboutengie.code_redeemers_boots.description_0"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/coderedeemer__layer_1.png";
        }
    }

    public static class Leggings
    extends CodeRedeemersItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.translatable((String)"item.allaboutengie.code_redeemers_leggings.description_0"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/coderedeemer__layer_2.png";
        }
    }

    public static class Chestplate
    extends CodeRedeemersItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.translatable((String)"item.allaboutengie.code_redeemers_chestplate.description_0"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/coderedeemer__layer_1.png";
        }
    }

    public static class Helmet
    extends CodeRedeemersItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.translatable((String)"item.allaboutengie.code_redeemers_helmet.description_0"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "allaboutengie:textures/models/armor/coderedeemer__layer_1.png";
        }
    }
}

