/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allaboutengie.network;

import java.util.function.Supplier;
import net.mcreator.allaboutengie.AllaboutengieMod;
import net.mcreator.allaboutengie.procedures.AntimatterEngieTradeUIButtonClickedProcedure;
import net.mcreator.allaboutengie.procedures.EngieGamesSwapFromAntimatterProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EngieAntimatterTradeUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public EngieAntimatterTradeUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public EngieAntimatterTradeUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(EngieAntimatterTradeUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(EngieAntimatterTradeUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> EngieAntimatterTradeUIButtonMessage.handleButtonAction((Player)context.getSender(), message.buttonID, message.x, message.y, message.z));
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AntimatterEngieTradeUIButtonClickedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            EngieGamesSwapFromAntimatterProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AllaboutengieMod.addNetworkMessage(EngieAntimatterTradeUIButtonMessage.class, EngieAntimatterTradeUIButtonMessage::buffer, EngieAntimatterTradeUIButtonMessage::new, EngieAntimatterTradeUIButtonMessage::handler);
    }
}

