/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allaboutengie.network;

import java.util.function.Supplier;
import net.mcreator.allaboutengie.AllaboutengieMod;
import net.mcreator.allaboutengie.procedures.AngryEngieBundleNameChangeProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AngryEngieBundleUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public AngryEngieBundleUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public AngryEngieBundleUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(AngryEngieBundleUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(AngryEngieBundleUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> AngryEngieBundleUIButtonMessage.handleButtonAction((Player)context.getSender(), message.buttonID, message.x, message.y, message.z));
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AngryEngieBundleNameChangeProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AllaboutengieMod.addNetworkMessage(AngryEngieBundleUIButtonMessage.class, AngryEngieBundleUIButtonMessage::buffer, AngryEngieBundleUIButtonMessage::new, AngryEngieBundleUIButtonMessage::handler);
    }
}

