/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allaboutengie.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelMadEngie<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"allaboutengie", (String)"model_mad_engie"), "main");
    public final ModelPart Head;
    public final ModelPart Body;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;

    public ModelMadEngie(ModelPart root) {
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(64, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(96, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)).texOffs(14, 98).addBox(4.05f, -5.2f, -1.2f, 1.4f, 2.4f, 2.4f, new CubeDeformation(0.0f)).texOffs(0, 95).addBox(4.2f, -6.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(22, 94).addBox(3.9f, -6.5f, -2.0f, 0.8f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(11, 88).addBox(3.9f, -6.0f, -2.5f, 0.8f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(14, 98).addBox(-5.5f, -5.2f, -1.2f, 1.4f, 2.4f, 2.4f, new CubeDeformation(0.0f)).texOffs(0, 95).addBox(-5.3f, -6.0f, -2.0f, 1.3f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(22, 94).mirror().addBox(-4.7f, -6.5f, -2.0f, 0.8f, 5.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(11, 88).addBox(-4.7f, -6.0f, -2.5f, 0.8f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 66).addBox(-4.4f, -8.3f, -1.0f, 0.4f, 2.7f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 66).addBox(4.0f, -8.3f, -1.0f, 0.4f, 2.7f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 39).addBox(-4.0f, -8.4f, -1.0f, 8.0f, 0.4f, 2.0f, new CubeDeformation(0.0f)).texOffs(81, 69).addBox(-4.1f, -5.95f, -5.0f, 8.2f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 125).mirror().addBox(-1.5f, -8.075f, 4.0f, 3.0f, 2.4f, 0.1f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 126).mirror().addBox(-4.1f, -5.675f, 4.0f, 8.2f, 1.5f, 0.1f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 118).addBox(-4.1f, -5.675f, -4.0f, 0.1f, 1.5f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 118).addBox(4.0f, -5.675f, -4.0f, 0.1f, 1.5f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 119).addBox(-1.5f, -8.075f, -3.975f, 3.0f, 0.1f, 7.975f, new CubeDeformation(0.0f)).texOffs(56, 64).addBox(-1.8f, -6.25f, -4.5f, 0.3f, 0.3f, 0.5f, new CubeDeformation(0.0f)).texOffs(55, 65).addBox(1.5f, -6.25f, -4.5f, 0.3f, 0.3f, 0.5f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = Head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 125).addBox(-1.5f, -2.5f, -0.05f, 3.0f, 2.5f, 0.1f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.6f, (float)-4.35f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = Head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(80, 79).mirror().addBox(-9.0f, -4.0f, -1.0f, 13.0f, 13.0f, 2.0f, new CubeDeformation(-5.49f)).mirror(false), PartPose.offsetAndRotation((float)-4.525f, (float)-7.45f, (float)-1.05f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r3 = Head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(80, 79).mirror().addBox(-9.0f, -4.0f, -1.0f, 13.0f, 13.0f, 2.0f, new CubeDeformation(-5.49f)).mirror(false), PartPose.offsetAndRotation((float)-0.525f, (float)-7.45f, (float)-1.05f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r4 = Head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(58, 78).addBox(-4.0f, -4.0f, -1.0f, 8.0f, 8.0f, 2.0f, new CubeDeformation(-2.99f)), PartPose.offsetAndRotation((float)1.975f, (float)-4.95f, (float)-3.525f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r5 = Head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(58, 78).addBox(-4.0f, -4.0f, -1.0f, 8.0f, 8.0f, 2.0f, new CubeDeformation(-2.99f)), PartPose.offsetAndRotation((float)-2.025f, (float)-4.95f, (float)-3.525f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r6 = Head.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(88, 70).addBox(-1.0f, -0.5f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.725f, (float)-5.625f, (float)-5.55f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition cube_r7 = Head.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(88, 70).addBox(-1.0f, -0.5f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.675f, (float)-5.625f, (float)-5.55f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(80, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(80, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(104, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(104, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(96, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(112, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(64, 16).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(64, 32).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(80, 48).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(64, 48).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

