/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allaboutengie.network;

import net.mcreator.allaboutengie.AllaboutengieMod;
import net.mcreator.allaboutengie.procedures.RecipeBookDownAllPagesProcedure;
import net.mcreator.allaboutengie.procedures.RecipeBookDownFivePagesProcedure;
import net.mcreator.allaboutengie.procedures.RecipeBookDownOnePageProcedure;
import net.mcreator.allaboutengie.procedures.RecipeBookUpFivePagesProcedure;
import net.mcreator.allaboutengie.procedures.RecipeBookUpMaxPagesProcedure;
import net.mcreator.allaboutengie.procedures.RecipeBookUpOnePageProcedure;
import net.mcreator.allaboutengie.procedures.SwapCraftsToAntimatterButtonClickedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CustomRecipeBookButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CustomRecipeBookButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"allaboutengie", (String)"custom_recipe_book_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomRecipeBookButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new CustomRecipeBookButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<CustomRecipeBookButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CustomRecipeBookButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> CustomRecipeBookButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RecipeBookUpOnePageProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            RecipeBookDownOnePageProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            RecipeBookUpFivePagesProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            RecipeBookDownFivePagesProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            RecipeBookUpMaxPagesProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            RecipeBookDownAllPagesProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            SwapCraftsToAntimatterButtonClickedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AllaboutengieMod.addNetworkMessage(TYPE, STREAM_CODEC, CustomRecipeBookButtonMessage::handleData);
    }
}

