/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allaboutengie.network;

import java.util.function.Supplier;
import net.mcreator.allaboutengie.AllaboutengieMod;
import net.mcreator.allaboutengie.procedures.RecipeBookDownAllPagesProcedure;
import net.mcreator.allaboutengie.procedures.RecipeBookDownFivePagesProcedure;
import net.mcreator.allaboutengie.procedures.RecipeBookDownOnePageProcedure;
import net.mcreator.allaboutengie.procedures.RecipeBookUpFivePagesProcedure;
import net.mcreator.allaboutengie.procedures.RecipeBookUpMaxPagesProcedure;
import net.mcreator.allaboutengie.procedures.RecipeBookUpOnePageProcedure;
import net.mcreator.allaboutengie.procedures.SwapCraftsToAntimatterButtonClickedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CustomRecipeBookButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CustomRecipeBookButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CustomRecipeBookButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CustomRecipeBookButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CustomRecipeBookButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> CustomRecipeBookButtonMessage.handleButtonAction((Player)context.getSender(), message.buttonID, message.x, message.y, message.z));
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RecipeBookUpOnePageProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            RecipeBookDownOnePageProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            RecipeBookUpFivePagesProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            RecipeBookDownFivePagesProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            RecipeBookUpMaxPagesProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            RecipeBookDownAllPagesProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            SwapCraftsToAntimatterButtonClickedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AllaboutengieMod.addNetworkMessage(CustomRecipeBookButtonMessage.class, CustomRecipeBookButtonMessage::buffer, CustomRecipeBookButtonMessage::new, CustomRecipeBookButtonMessage::handler);
    }
}

