/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat;

import com.nonxedy.nonchat.api.ChannelAPI;
import com.nonxedy.nonchat.command.impl.IgnoreCommand;
import com.nonxedy.nonchat.command.impl.SpyCommand;
import com.nonxedy.nonchat.core.BroadcastManager;
import com.nonxedy.nonchat.core.ChatManager;
import com.nonxedy.nonchat.core.MessageManager;
import com.nonxedy.nonchat.hook.DiscordSRVHook;
import com.nonxedy.nonchat.integration.DiscordSRVIntegration;
import com.nonxedy.nonchat.listener.ChatListener;
import com.nonxedy.nonchat.listener.ChatListenerFactory;
import com.nonxedy.nonchat.listener.DeathCoordinates;
import com.nonxedy.nonchat.listener.DeathListener;
import com.nonxedy.nonchat.listener.DiscordSRVListener;
import com.nonxedy.nonchat.listener.JoinQuitListener;
import com.nonxedy.nonchat.placeholders.NonchatExpansion;
import com.nonxedy.nonchat.placeholders.impl.ConfigurablePlaceholder;
import com.nonxedy.nonchat.service.ChatService;
import com.nonxedy.nonchat.service.CommandService;
import com.nonxedy.nonchat.service.ConfigService;
import com.nonxedy.nonchat.util.InteractivePlaceholderManager;
import com.nonxedy.nonchat.util.chat.filters.LinkDetector;
import com.nonxedy.nonchat.util.chat.packets.DisplayEntityUtil;
import com.nonxedy.nonchat.util.core.debugging.Debugger;
import com.nonxedy.nonchat.util.core.updates.UpdateChecker;
import com.nonxedy.nonchat.util.integration.external.IntegrationUtil;
import com.nonxedy.nonchat.util.integration.metrics.Metrics;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nonchat
extends JavaPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Nonchat.class);
    private ChatService chatService;
    private CommandService commandService;
    private ConfigService configService;
    private ChatManager chatManager;
    private MessageManager messageManager;
    private BroadcastManager broadcastManager;
    private SpyCommand spyCommand;
    private Debugger debugger;
    private ChatListener chatListener;
    private IgnoreCommand ignoreCommand;
    private DiscordSRVHook discordSRVHook;
    private DiscordSRVListener discordSRVListener;
    private DiscordSRVIntegration discordSRVIntegration;
    private Metrics metrics;
    private InteractivePlaceholderManager placeholderManager;
    private final Map<Player, List<TextDisplay>> bubbles = new HashMap<Player, List<TextDisplay>>();

    public void onEnable() {
        try {
            this.saveDefaultConfig();
            if (!new File(this.getDataFolder(), "langs/messages_en.yml").exists()) {
                this.saveResource("langs/messages_en.yml", false);
            }
            if (!new File(this.getDataFolder(), "langs/messages_ru.yml").exists()) {
                this.saveResource("langs/messages_ru.yml", false);
            }
            if (!new File(this.getDataFolder(), "langs/messages_es.yml").exists()) {
                this.saveResource("langs/messages_es.yml", false);
            }
            this.initializeServices();
            this.registerPlaceholders();
            this.registerListeners();
            this.setupIntegrations();
            Bukkit.getConsoleSender().sendMessage("\u00a7d[nonchat] \u00a7aplugin enabled");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to enable plugin: {0}", e.getMessage());
            throw new RuntimeException("Failed to enable plugin", e);
        }
    }

    private void initializeServices() {
        try {
            this.configService = new ConfigService(this);
            this.spyCommand = new SpyCommand(this, this.configService.getMessages(), this.configService.getConfig());
            this.ignoreCommand = new IgnoreCommand(this, this.configService.getMessages());
            this.chatManager = new ChatManager(this, this.configService.getConfig(), this.configService.getMessages());
            this.messageManager = new MessageManager(this, this.configService.getConfig(), this.configService.getMessages(), this.spyCommand);
            this.broadcastManager = new BroadcastManager(this, this.configService.getConfig());
            this.chatManager.setIgnoreCommand(this.ignoreCommand);
            this.messageManager.setIgnoreCommand(this.ignoreCommand);
            LinkDetector.initialize(this.configService.getMessages());
            this.chatService = new ChatService(this.chatManager, this.messageManager, this.broadcastManager, this.configService.getConfig());
            this.commandService = new CommandService(this, this.chatService, this.configService);
            this.initializeInteractivePlaceholders();
            if (this.configService.getConfig().isDebug()) {
                this.debugger = new Debugger(this, this.configService.getConfig().getDebugLogRetentionDays());
                this.debugger.info("Core", "Services initialized successfully");
            }
            this.getLogger().info("Core services initialized successfully");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize core services: {0}", e.getMessage());
            throw new RuntimeException("Failed to initialize core services", e);
        }
    }

    private void initializeInteractivePlaceholders() {
        try {
            this.placeholderManager = new InteractivePlaceholderManager();
            this.registerBuiltInPlaceholders();
            this.loadCustomPlaceholdersFromConfig();
            this.getLogger().info("Interactive placeholders initialized successfully");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize interactive placeholders: {0}", e.getMessage());
            throw new RuntimeException("Failed to initialize interactive placeholders", e);
        }
    }

    private void registerBuiltInPlaceholders() {
        this.getLogger().info("Built-in interactive placeholders will be loaded from config");
    }

    private void loadCustomPlaceholdersFromConfig() {
        try {
            ConfigurationSection customPlaceholdersSection = this.getConfig().getConfigurationSection("interactive-placeholders.custom-placeholders");
            if (customPlaceholdersSection != null) {
                int loadedCount = 0;
                for (String placeholderKey : customPlaceholdersSection.getKeys(false)) {
                    ConfigurationSection placeholderConfig = customPlaceholdersSection.getConfigurationSection(placeholderKey);
                    if (placeholderConfig == null || !placeholderConfig.getBoolean("enabled", false)) continue;
                    String displayName = placeholderConfig.getString("display-name", placeholderKey);
                    String description = placeholderConfig.getString("description", "");
                    String permission = placeholderConfig.getString("permission", "");
                    String activationKey = placeholderConfig.getString("placeholder", placeholderKey);
                    String format = placeholderConfig.getString("format", "[" + activationKey + "]");
                    List hoverText = placeholderConfig.getStringList("hover-text");
                    String clickActionType = "none";
                    String clickActionValue = "";
                    ConfigurationSection clickActionSection = placeholderConfig.getConfigurationSection("click-action");
                    if (clickActionSection != null) {
                        clickActionType = clickActionSection.getString("type", "none");
                        clickActionValue = clickActionSection.getString("value", "");
                    }
                    ConfigurablePlaceholder placeholder = new ConfigurablePlaceholder(placeholderKey, activationKey, displayName, description, true, permission, format, hoverText, clickActionType, clickActionValue);
                    this.placeholderManager.registerPlaceholder(placeholder);
                    ++loadedCount;
                }
                this.getLogger().info("Loaded " + loadedCount + " custom interactive placeholders from config");
            } else {
                this.getLogger().info("No custom placeholders section found in config");
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to load custom placeholders from config: {0}", e.getMessage());
        }
    }

    private void reloadInteractivePlaceholders() {
        try {
            if (this.placeholderManager != null) {
                this.placeholderManager.clearPlaceholders();
                this.loadCustomPlaceholdersFromConfig();
                this.getLogger().info("Interactive placeholders reloaded successfully");
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to reload interactive placeholders: {0}", e.getMessage());
        }
    }

    private void registerListeners() {
        try {
            ChatListener chatListener = ChatListenerFactory.createChatListener(this, this.chatManager, this.chatService);
            this.getServer().getPluginManager().registerEvents((Listener)chatListener, (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)new DeathListener(this.configService.getConfig()), (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)new DeathCoordinates(this.configService.getConfig(), this.configService.getMessages()), (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)new JoinQuitListener(this.configService.getConfig(), this.chatManager.getChannelManager()), (Plugin)this);
            if (this.debugger != null) {
                this.debugger.info("Events", "Event listeners registered successfully");
            }
            this.getLogger().info("Event listeners registered successfully");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to register event listeners: {0}", e.getMessage());
            throw new RuntimeException("Failed to register event listeners", e);
        }
    }

    private void registerPlaceholders() {
        try {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                new NonchatExpansion(this).register();
                this.getLogger().info("PlaceholderAPI expansion registered successfully");
            } else {
                this.getLogger().info("PlaceholderAPI not available - placeholders will be disabled");
            }
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().info("PlaceholderAPI not installed - placeholders will be disabled");
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to register PlaceholderAPI expansion: {0}", e.getMessage());
        }
    }

    private void setupIntegrations() {
        try {
            IntegrationUtil.setupIntegrations();
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().info("Some external integrations not available - features will be disabled");
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to setup external integrations: {0}", e.getMessage());
        }
        try {
            this.metrics = new Metrics((Plugin)this, 25786);
            this.getLogger().info("Metrics initialized successfully");
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().info("Metrics not available - metrics will be disabled");
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to initialize metrics: {0}", e.getMessage());
        }
        try {
            this.discordSRVHook = new DiscordSRVHook(this);
            ChannelAPI.initialize(this);
            if (Bukkit.getPluginManager().getPlugin("DiscordSRV") != null) {
                this.discordSRVListener = new DiscordSRVListener(this);
                this.discordSRVIntegration = new DiscordSRVIntegration(this);
                this.getLogger().info("DiscordSRV integration enabled");
            } else {
                this.getLogger().info("DiscordSRV not available - Discord integration will be disabled");
            }
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().info("DiscordSRV not installed - Discord integration will be disabled");
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to setup DiscordSRV integration: {0}", e.getMessage());
        }
        try {
            if (this.configService.getConfig().isUpdateCheckerEnabled()) {
                this.getLogger().info("Initializing update checker...");
                new UpdateChecker(this);
                if (this.debugger != null) {
                    this.debugger.info("Updates", "Update checker initialized");
                }
                this.getLogger().info("Update checker initialized successfully");
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to initialize update checker: {0}", e.getMessage());
        }
    }

    public void onDisable() {
        try {
            if (this.chatManager != null) {
                this.chatManager.cleanup();
            }
            DisplayEntityUtil.clearPool();
            if (this.broadcastManager != null) {
                this.broadcastManager.stop();
            }
            if (this.commandService != null) {
                this.commandService.unregisterAll();
            }
            if (this.discordSRVListener != null) {
                this.discordSRVListener.shutdown();
            }
            if (this.discordSRVIntegration != null) {
                this.discordSRVIntegration.unregister();
            }
            Bukkit.getConsoleSender().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"[nonchat] ", (TextColor)TextColor.fromHexString((String)"#E088FF")))).append((Component)Component.text((String)"plugin disabled", (TextColor)TextColor.fromHexString((String)"#FF5252"))));
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error during plugin shutdown: {0}", e.getMessage());
        }
    }

    public void reloadConfig() {
        try {
            super.reloadConfig();
            if (this.configService != null) {
                this.configService.reload();
            }
            if (this.broadcastManager != null) {
                this.broadcastManager.reload();
            }
            if (this.configService != null) {
                LinkDetector.initialize(this.configService.getMessages());
            }
            if (this.commandService != null) {
                this.commandService.reloadCommands();
            }
            this.reloadInteractivePlaceholders();
            this.getLogger().info("Configuration reloaded successfully");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to reload configuration: {0}", e.getMessage());
            throw new RuntimeException("Failed to reload configuration", e);
        }
    }

    public void reloadServices() {
        try {
            if (this.broadcastManager != null) {
                this.broadcastManager.stop();
            }
            if (this.configService != null) {
                this.configService.reload();
            }
            if (this.broadcastManager != null) {
                this.broadcastManager.reload();
            }
            if (this.configService != null) {
                LinkDetector.initialize(this.configService.getMessages());
            }
            if (this.commandService != null) {
                this.commandService.reloadCommands();
            }
            if (this.chatManager != null) {
                this.chatManager.reloadChannels();
            }
            this.reloadInteractivePlaceholders();
            if (this.configService != null && this.configService.getConfig().isDebug()) {
                if (this.debugger == null) {
                    this.debugger = new Debugger(this, this.configService.getConfig().getDebugLogRetentionDays());
                }
            } else {
                this.debugger = null;
            }
            this.getLogger().info("Services reloaded successfully");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to reload services: {0}", e.getMessage());
            throw new RuntimeException("Failed to reload services", e);
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        try {
            List<TextDisplay> playerBubbles = this.bubbles.remove(event.getPlayer());
            if (playerBubbles != null) {
                DisplayEntityUtil.removeBubbles(playerBubbles);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Error handling player teleport: {0}", e.getMessage());
        }
    }

    public void logCommand(String command, String[] args) {
        try {
            if (this.debugger != null) {
                this.debugger.debug("Commands", command + " Args: " + Arrays.toString(args));
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Failed to log command: {0}", e.getMessage());
        }
    }

    public void logResponse(String response) {
        try {
            if (this.debugger != null) {
                this.debugger.debug("API", "Response: " + response);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Failed to log response: {0}", e.getMessage());
        }
    }

    public void logError(String error) {
        try {
            if (this.debugger != null) {
                this.debugger.error("System", "Error occurred", new Exception(error));
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Failed to log error: {0}", e.getMessage());
        }
    }

    public void logPlaceholder(String placeholder, String result) {
        try {
            if (this.debugger != null) {
                this.debugger.debug("Placeholders", placeholder + " -> " + result);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Failed to log placeholder: {0}", e.getMessage());
        }
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public SpyCommand getSpyCommand() {
        return this.spyCommand;
    }

    public IgnoreCommand getIgnoreCommand() {
        return this.ignoreCommand;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public InteractivePlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }
}

