/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.command.impl;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RollCommand
implements CommandExecutor,
TabCompleter {
    private final Random random = new Random();
    private final Nonchat plugin;
    private final PluginConfig config;
    private final PluginMessages messages;

    public RollCommand(Nonchat plugin, PluginConfig config, PluginMessages messages) {
        this.plugin = plugin;
        this.config = config;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        this.plugin.logCommand(command.getName(), args);
        if (!this.config.isRollCommandEnabled()) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("command-disabled")));
            this.plugin.logError("Player " + sender.getName() + " tried to use disabled roll command");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("player-only")));
            this.plugin.logError("Roll command can only be used by players");
            return true;
        }
        if (!sender.hasPermission("nonchat.roll")) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            this.plugin.logError("Player " + sender.getName() + " tried to use roll command without permission");
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-usage-roll")));
            this.plugin.logError("Player " + sender.getName() + " tried to use roll command without max number");
            return true;
        }
        try {
            int maxNumber = Integer.parseInt(args[0]);
            if (maxNumber <= 0) {
                sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-number")));
                this.plugin.logError("Player " + sender.getName() + " tried to use roll command with invalid number");
                return true;
            }
            int rolledNumber = this.random.nextInt(maxNumber) + 1;
            String format = this.config.getRollFormat().replace("{number}", String.valueOf(rolledNumber));
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                try {
                    format = PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)format);
                }
                catch (Exception e) {
                    this.plugin.logError("Failed to process PlaceholderAPI placeholders for roll command: " + e.getMessage());
                }
            }
            sender.getServer().broadcast(ColorUtil.parseComponent(format));
            this.plugin.logResponse("Player " + sender.getName() + " used roll command");
            return true;
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-number")));
            this.plugin.logError("Player " + sender.getName() + " tried to use roll command with invalid number");
            return true;
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("nonchat.roll")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            List<String> suggestions = Arrays.asList("100");
            return suggestions.stream().filter(s -> s.startsWith(args[0])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

