/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.config;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.util.chat.filters.CapsFilter;
import com.nonxedy.nonchat.util.chat.filters.WordBlocker;
import com.nonxedy.nonchat.util.chat.formatting.ChatTypeUtil;
import com.nonxedy.nonchat.util.chat.formatting.HoverTextUtil;
import com.nonxedy.nonchat.util.core.broadcast.BroadcastMessage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class PluginConfig {
    private final Nonchat plugin;
    private final File configFile;
    private FileConfiguration config;
    private boolean debug;
    private String language;
    private String defaultChannel;

    public PluginConfig(Nonchat plugin) {
        this.plugin = plugin;
        this.configFile = new File("plugins/nonchat", "config.yml");
        this.loadConfig();
    }

    public void loadConfig() {
        if (!this.configFile.exists()) {
            this.createDefaultConfig();
        } else {
            this.updateConfigIfNeeded();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.debug = this.config.getBoolean("debug", false);
        this.language = this.config.getString("language", "en");
        this.defaultChannel = this.config.getString("default-channel", "local");
    }

    private void createDefaultConfig() {
        try {
            this.configFile.getParentFile().mkdirs();
            this.configFile.createNewFile();
            this.config = new YamlConfiguration();
            this.setDefaultValues();
            this.saveConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create default config", e);
        }
    }

    private void setDefaultValues() {
        this.config.set("language", (Object)"en");
        this.config.set("debug", (Object)false);
        this.config.set("update-checker", (Object)true);
        this.config.set("default-channel", (Object)"local");
        this.config.set("message-delivery.notify-undelivered", (Object)true);
        this.config.set("death.enabled", (Object)true);
        this.config.set("death.format", (Object)"%luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%\u00a7f died");
        this.config.set("death.show-coordinates", (Object)true);
        this.config.set("join-messages.enabled", (Object)true);
        this.config.set("join-messages.format", (Object)"\u00a78(\u00a7a+\u00a78) %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%");
        this.config.set("quit-messages.enabled", (Object)true);
        this.config.set("quit-messages.format", (Object)"\u00a78(\u00a7c-\u00a78) %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%");
        this.config.set("private-chat.sender-format", (Object)"\u00a77[\u00a7aTo \u00a7f{target}\u00a77] \u00a77{message}");
        this.config.set("private-chat.receiver-format", (Object)"\u00a77[\u00a7cFrom \u00a7f{sender}\u00a77] \u00a77{message}");
        this.config.set("private-chat.hover.enabled", (Object)true);
        this.config.set("private-chat.hover.sender-hover", Arrays.asList("\u00a77Sent to: \u00a7f{target}", "\u00a77Time: \u00a7f{time}", "\u00a77Click to send another message"));
        this.config.set("private-chat.hover.receiver-hover", Arrays.asList("\u00a77From: \u00a7f{sender}", "\u00a77Time: \u00a7f{time}", "\u00a77Click to reply"));
        this.config.set("spy-format", (Object)"\u00a7f{sender} \u00a77-> \u00a7f{target}\u00a77: \u00a77{message}");
        this.config.set("chat-bubbles.enabled", (Object)true);
        this.config.set("chat-bubbles.duration", (Object)5);
        this.config.set("chat-bubbles.height", (Object)2.5);
        this.config.set("chat-bubbles.scale", (Object)1.0);
        this.config.set("chat-bubbles.scale-x", (Object)1.0);
        this.config.set("chat-bubbles.scale-y", (Object)1.0);
        this.config.set("chat-bubbles.scale-z", (Object)1.0);
        this.createDefaultChannels();
        this.config.set("roleplay-commands.me.enabled", (Object)true);
        this.config.set("roleplay-commands.me.format", (Object)"&7*%player_name%: {message}");
        this.config.set("roleplay-commands.roll.enabled", (Object)true);
        this.config.set("roleplay-commands.roll.format", (Object)"&7*%player_name% rolled a {number}");
        this.config.set("hover-text.enabled", (Object)true);
        List<String> defaultHoverFormat = Arrays.asList("&#FFAFFB\u2b50 %player_name%", "&#FFAFFB\u25ba Rank: &#FFFFFF%luckperms_prefix%", "&#FFAFFB\u25ba Balance: &#FFFFFF$%vault_eco_balance%", "&#FFAFFB\u25ba Level: &#FFFFFF%player_level%", "&#FFAFFB\u25ba Playtime: &#FFFFFF%statistic_time_played%", "&#FFAFFB\u25ba Location: &#FFFFFF%player_world%", "&#FFAFFB\u25ba Ping: &#FFFFFF%player_ping%ms", "\u00a77", "\u00a78Click to send a private message");
        this.config.set("hover-text.format", defaultHoverFormat);
        this.config.set("banned-words", Arrays.asList("spam", "badword", "anotherbadword", "\u043f\u043b\u043e\u0445\u043e\u0439"));
        this.config.set("banned-patterns", Arrays.asList(".*\\btest\\b.*", ".*\\d{4,}.*"));
        this.config.set("caps-filter.enabled", (Object)true);
        this.config.set("caps-filter.max-caps-percentage", (Object)70);
        this.config.set("caps-filter.min-length", (Object)4);
        this.config.set("broadcast.format", (Object)"\n\u00a7#FFAFFBBroadcast: \u00a7f{message}\n");
        this.config.set("broadcast.random", (Object)true);
        this.config.set("broadcast.example.enabled", (Object)true);
        this.config.set("broadcast.example.message", (Object)"This message will be sent every 60 seconds");
        this.config.set("broadcast.example.interval", (Object)60);
        this.config.set("anti-ad.enabled", (Object)true);
        this.config.set("anti-ad.sensitivity", (Object)0.7);
        this.config.set("anti-ad.whitelisted-urls", Arrays.asList("discord.gg/NAWsxe3J3R"));
        this.config.set("anti-ad.staff-notify", (Object)true);
        this.config.set("anti-ad.punish-command", (Object)"ban %player% advertising");
    }

    private void createDefaultChannels() {
        this.config.set("channels.global.enabled", (Object)true);
        this.config.set("channels.global.display-name", (Object)"Global");
        this.config.set("channels.global.format", (Object)"\u00a77(\u00a76G\u00a77)\u00a7r %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%\u00a77: \u00a7f{message}");
        this.config.set("channels.global.radius", (Object)-1);
        this.config.set("channels.global.character", (Object)"!");
        this.config.set("channels.global.send-permission", (Object)"");
        this.config.set("channels.global.receive-permission", (Object)"");
        this.config.set("channels.global.cooldown", (Object)0);
        this.config.set("channels.global.min-length", (Object)0);
        this.config.set("channels.global.max-length", (Object)-1);
        this.config.set("channels.local.enabled", (Object)true);
        this.config.set("channels.local.display-name", (Object)"Local");
        this.config.set("channels.local.format", (Object)"\u00a77(\u00a76L\u00a77)\u00a7r %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%\u00a77: \u00a7f{message}");
        this.config.set("channels.local.radius", (Object)100);
        this.config.set("channels.local.character", (Object)"");
        this.config.set("channels.local.send-permission", (Object)"");
        this.config.set("channels.local.receive-permission", (Object)"");
        this.config.set("channels.local.cooldown", (Object)0);
        this.config.set("channels.local.min-length", (Object)0);
        this.config.set("channels.local.max-length", (Object)-1);
        this.config.set("channels.staff.enabled", (Object)true);
        this.config.set("channels.staff.display-name", (Object)"Staff");
        this.config.set("channels.staff.format", (Object)"\u00a77(\u00a7bSC\u00a77)\u00a7r %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%\u00a77: \u00a7f{message}");
        this.config.set("channels.staff.radius", (Object)-1);
        this.config.set("channels.staff.character", (Object)"*");
        this.config.set("channels.staff.send-permission", (Object)"nonchat.chat.staff");
        this.config.set("channels.staff.receive-permission", (Object)"nonchat.chat.staff");
        this.config.set("channels.staff.cooldown", (Object)0);
        this.config.set("channels.staff.min-length", (Object)0);
        this.config.set("channels.staff.max-length", (Object)-1);
    }

    @NotNull
    public String getLanguage() {
        return this.language;
    }

    @NotNull
    public String getDefaultChannel() {
        return this.defaultChannel;
    }

    public boolean isUndeliveredMessageNotificationEnabled() {
        return this.config.getBoolean("message-delivery.notify-undelivered", true);
    }

    public void setUndeliveredMessageNotificationEnabled(boolean enabled) {
        this.config.set("message-delivery.notify-undelivered", (Object)enabled);
        this.saveConfig();
    }

    public boolean isInteractivePlaceholdersEnabled() {
        return this.config.getBoolean("interactive-placeholders.enabled", true);
    }

    public void setInteractivePlaceholdersEnabled(boolean enabled) {
        this.config.set("interactive-placeholders.enabled", (Object)enabled);
        this.saveConfig();
    }

    @NotNull
    public Map<String, ConfigurationSection> getCustomPlaceholders() {
        HashMap<String, ConfigurationSection> placeholders = new HashMap<String, ConfigurationSection>();
        ConfigurationSection customPlaceholdersSection = this.config.getConfigurationSection("interactive-placeholders.custom-placeholders");
        if (customPlaceholdersSection != null) {
            for (String key : customPlaceholdersSection.getKeys(false)) {
                ConfigurationSection placeholderConfig = customPlaceholdersSection.getConfigurationSection(key);
                if (placeholderConfig == null) continue;
                placeholders.put(key, placeholderConfig);
            }
        }
        return placeholders;
    }

    public boolean isCustomPlaceholderEnabled(String placeholderKey) {
        return this.config.getBoolean("interactive-placeholders.custom-placeholders." + placeholderKey + ".enabled", false);
    }

    @NotNull
    public String getCustomPlaceholderActivation(String placeholderKey) {
        return this.config.getString("interactive-placeholders.custom-placeholders." + placeholderKey + ".placeholder", placeholderKey);
    }

    @NotNull
    public String getCustomPlaceholderDisplayName(String placeholderKey) {
        return this.config.getString("interactive-placeholders.custom-placeholders." + placeholderKey + ".display-name", placeholderKey);
    }

    @NotNull
    public String getCustomPlaceholderFormat(String placeholderKey) {
        return this.config.getString("interactive-placeholders.custom-placeholders." + placeholderKey + ".format", "[" + placeholderKey + "]");
    }

    @NotNull
    public String getCustomPlaceholderPermission(String placeholderKey) {
        return this.config.getString("interactive-placeholders.custom-placeholders." + placeholderKey + ".permission", "");
    }

    @NotNull
    public List<String> getCustomPlaceholderHoverText(String placeholderKey) {
        return this.config.getStringList("interactive-placeholders.custom-placeholders." + placeholderKey + ".hover-text");
    }

    @NotNull
    public String getCustomPlaceholderClickActionType(String placeholderKey) {
        ConfigurationSection clickActionSection = this.config.getConfigurationSection("interactive-placeholders.custom-placeholders." + placeholderKey + ".click-action");
        if (clickActionSection != null) {
            return clickActionSection.getString("type", "none");
        }
        return "none";
    }

    @NotNull
    public String getCustomPlaceholderClickActionValue(String placeholderKey) {
        ConfigurationSection clickActionSection = this.config.getConfigurationSection("interactive-placeholders.custom-placeholders." + placeholderKey + ".click-action");
        if (clickActionSection != null) {
            return clickActionSection.getString("value", "");
        }
        return "";
    }

    public boolean isDeathMessagesEnabled() {
        return this.config.getBoolean("death.enabled", true);
    }

    public boolean isShowDeathCoordinatesEnabled() {
        return this.config.getBoolean("death.show-coordinates", true);
    }

    @NotNull
    public String getDeathFormat() {
        return this.config.getString("death.format", "%luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%\u00a7f died");
    }

    public boolean isJoinMessageEnabled() {
        return this.config.getBoolean("join-messages.enabled", true);
    }

    @NotNull
    public String getJoinFormat() {
        return this.config.getString("join-messages.format", "\u00a78(\u00a7a+\u00a78) %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%");
    }

    public boolean isQuitMessageEnabled() {
        return this.config.getBoolean("quit-messages.enabled", true);
    }

    @NotNull
    public String getQuitFormat() {
        return this.config.getString("quit-messages.format", "\u00a78(\u00a7c-\u00a78) %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%");
    }

    public boolean isJoinSoundEnabled() {
        return this.config.getBoolean("join-messages.sound-enabled", true);
    }

    @NotNull
    public String getJoinSound() {
        return this.config.getString("join-messages.sound", "entity.experience_orb.pickup");
    }

    public float getJoinSoundVolume() {
        return (float)this.config.getDouble("join-messages.sound-volume", 1.0);
    }

    public float getJoinSoundPitch() {
        return (float)this.config.getDouble("join-messages.sound-pitch", 1.0);
    }

    public boolean isQuitSoundEnabled() {
        return this.config.getBoolean("quit-messages.sound-enabled", true);
    }

    @NotNull
    public String getQuitSound() {
        return this.config.getString("quit-messages.sound", "entity.villager.no");
    }

    public float getQuitSoundVolume() {
        return (float)this.config.getDouble("quit-messages.sound-volume", 1.0);
    }

    public float getQuitSoundPitch() {
        return (float)this.config.getDouble("quit-messages.sound-pitch", 1.0);
    }

    public boolean isMentionSoundEnabled() {
        return this.config.getBoolean("mention-sounds.enabled", true);
    }

    @NotNull
    public String getMentionSound() {
        return this.config.getString("mention-sounds.sound", "entity.experience_orb.pickup");
    }

    public float getMentionSoundVolume() {
        return (float)this.config.getDouble("mention-sounds.volume", 1.0);
    }

    public float getMentionSoundPitch() {
        return (float)this.config.getDouble("mention-sounds.pitch", 1.0);
    }

    public boolean isMentionColoringEnabled() {
        return this.config.getBoolean("mention-colors.enabled", true);
    }

    @NotNull
    public String getMentionColor() {
        return this.config.getString("mention-colors.color", "&#FFAFFB");
    }

    @NotNull
    public String getPrivateChatSenderFormat() {
        return this.config.getString("private-chat.sender.format", "\u00a78[\u00a7fYou \u00a78-> \u00a7f{receiver}\u00a78] \u00a7f{message}");
    }

    @NotNull
    public String getPrivateChatReceiverFormat() {
        return this.config.getString("private-chat.receiver.format", "\u00a78[\u00a7f{sender} \u00a78-> \u00a7fYou\u00a78] \u00a7f{message}");
    }

    public boolean isPrivateChatSenderHoverEnabled() {
        return this.config.getBoolean("private-chat.sender.hover.enabled", true);
    }

    public boolean isPrivateChatReceiverHoverEnabled() {
        return this.config.getBoolean("private-chat.receiver.hover.enabled", true);
    }

    @NotNull
    public List<String> getPrivateChatSenderHover() {
        return this.config.getStringList("private-chat.sender.hover.text");
    }

    @NotNull
    public List<String> getPrivateChatReceiverHover() {
        return this.config.getStringList("private-chat.receiver.hover.text");
    }

    public boolean isPrivateChatClickActionsEnabled() {
        return this.config.getBoolean("private-chat.click-actions.enabled", true);
    }

    @NotNull
    public String getPrivateChatReplyCommand() {
        return this.config.getString("private-chat.click-actions.reply-command", "/msg {sender} ");
    }

    @NotNull
    public String getSpyFormat() {
        return this.config.getString("spy-format", "\u00a7f{sender} \u00a77-> \u00a7f{target}\u00a77: \u00a77{message}");
    }

    public boolean isBroadcastEnabled() {
        return this.config.getBoolean("broadcast.enabled", true);
    }

    @NotNull
    public String getBroadcastFormat() {
        return this.config.getString("broadcast.format", "\n\u00a7#FFAFFBBroadcast: \u00a7f{message}\n");
    }

    public void setBroadcastFormat(String format) {
        this.config.set("broadcast.format", (Object)format);
        this.saveConfig();
    }

    public boolean isRandomBroadcastEnabled() {
        return this.config.getBoolean("broadcast.random", false);
    }

    @NotNull
    public String getBroadcastMessage() {
        return this.config.getString("broadcast.message", "Default broadcast message");
    }

    public int getBroadcastInterval() {
        return this.config.getInt("broadcast.interval", 60);
    }

    @NotNull
    public Map<String, BroadcastMessage> getBroadcastMessages() {
        HashMap<String, BroadcastMessage> messages = new HashMap<String, BroadcastMessage>();
        ConfigurationSection section = this.config.getConfigurationSection("broadcast");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                ConfigurationSection messageSection;
                if (key.equals("random") || (messageSection = section.getConfigurationSection(key)) == null) continue;
                messages.put(key, this.createBroadcastMessage(messageSection.getBoolean("enabled", true), messageSection.getString("message", "Default message"), messageSection.getInt("interval", 60)));
            }
        }
        return messages;
    }

    public boolean isChatBubblesEnabled() {
        return this.config.getBoolean("chat-bubbles.enabled", true);
    }

    public int getChatBubblesDuration() {
        return this.config.getInt("chat-bubbles.duration", 5);
    }

    public double getChatBubblesHeight() {
        return this.config.getDouble("chat-bubbles.height", 2.5);
    }

    public double getChatBubblesScale() {
        return this.config.getDouble("chat-bubbles.scale", 1.0);
    }

    public double getChatBubblesScaleX() {
        return this.config.getDouble("chat-bubbles.scale-x", 1.0);
    }

    public double getChatBubblesScaleY() {
        return this.config.getDouble("chat-bubbles.scale-y", 1.0);
    }

    public double getChatBubblesScaleZ() {
        return this.config.getDouble("chat-bubbles.scale-z", 1.0);
    }

    @NotNull
    public List<String> getBannedWords() {
        return this.config.getStringList("banned-words");
    }

    @NotNull
    public List<String> getBannedPatterns() {
        return this.config.getStringList("banned-patterns");
    }

    @NotNull
    public WordBlocker getWordBlocker() {
        return new WordBlocker(this.getBannedWords(), this.getBannedPatterns());
    }

    public BroadcastMessage createBroadcastMessage(boolean enabled, String message, int interval) {
        return new BroadcastMessage(enabled, message, interval);
    }

    public boolean isUpdateCheckerEnabled() {
        return this.config.getBoolean("update-checker", true);
    }

    public ChatTypeUtil getChatTypeByChar(char prefix) {
        Map<String, ChatTypeUtil> chats = this.getChats();
        return chats.values().stream().filter(chat -> chat.getChatChar() == prefix).findFirst().orElse(this.getDefaultChatType());
    }

    public ChatTypeUtil getDefaultChatType() {
        return this.getChats().getOrDefault("local", new ChatTypeUtil(true, "\u00a77(\u00a76L\u00a77)\u00a7r {prefix} \u00a7f{sender}\u00a7r {suffix}\u00a77: \u00a7f{message}", 100, '\u0000', null));
    }

    public boolean isChatEnabled(String channelId) {
        return this.config.getBoolean("channels." + channelId + ".enabled", false);
    }

    public void setChatEnabled(String channelId, boolean enabled) {
        this.config.set("channels." + channelId + ".enabled", (Object)enabled);
        this.saveConfig();
    }

    public Map<String, ChatTypeUtil> getChats() {
        ConfigurationSection oldSection;
        char chatChar;
        String charStr;
        int radius;
        String format;
        HashMap<String, ChatTypeUtil> channels = new HashMap<String, ChatTypeUtil>();
        ConfigurationSection section = this.config.getConfigurationSection("channels");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                ConfigurationSection channelSection = section.getConfigurationSection(key);
                if (channelSection == null) continue;
                boolean enabled = channelSection.getBoolean("enabled", true);
                String displayName = channelSection.getString("display-name", key);
                format = channelSection.getString("format", "{prefix} {sender} {suffix}: {message}");
                radius = channelSection.getInt("radius", -1);
                charStr = channelSection.getString("character", "");
                chatChar = charStr.isEmpty() ? (char)'\u0000' : charStr.charAt(0);
                String sendPermission = channelSection.getString("send-permission", "");
                if (sendPermission.isEmpty() && channelSection.contains("permission")) {
                    sendPermission = channelSection.getString("permission");
                }
                String receivePermission = channelSection.getString("receive-permission", "");
                int cooldown = channelSection.getInt("cooldown", 0);
                int minLength = channelSection.getInt("min-length", 0);
                int maxLength = channelSection.getInt("max-length", -1);
                channels.put(key, new ChatTypeUtil(enabled, displayName, format, radius, chatChar, sendPermission, receivePermission, cooldown, minLength, maxLength));
            }
        }
        if ((oldSection = this.config.getConfigurationSection("chats")) != null && channels.isEmpty()) {
            for (String key : oldSection.getKeys(false)) {
                ConfigurationSection chatSection = oldSection.getConfigurationSection(key);
                if (chatSection == null) continue;
                boolean enabled = chatSection.getBoolean("enabled", true);
                format = chatSection.getString("format", "{prefix} {sender} {suffix}: {message}");
                radius = chatSection.getInt("radius", -1);
                charStr = chatSection.getString("char", "");
                chatChar = charStr.isEmpty() ? (char)'\u0000' : charStr.charAt(0);
                String permission = null;
                if (chatSection.contains("permission")) {
                    permission = chatSection.getString("permission");
                }
                channels.put(key, new ChatTypeUtil(enabled, format, radius, chatChar, permission));
            }
        }
        return channels;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getDebugLogRetentionDays() {
        return this.config.getInt("debug-log-retention-days", 7);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.config.set("debug", (Object)debug);
        this.saveConfig();
    }

    public boolean isMeCommandEnabled() {
        return this.config.getBoolean("roleplay-commands.me.enabled", true);
    }

    public String getMeFormat() {
        return this.config.getString("roleplay-commands.me.format", "&7*%player_name%: {message}");
    }

    public boolean isRollCommandEnabled() {
        return this.config.getBoolean("roleplay-commands.roll.enabled", true);
    }

    public String getRollFormat() {
        return this.config.getString("roleplay-commands.roll.format", "&7*%player_name% rolled a {number}");
    }

    public boolean isCapsFilterEnabled() {
        return this.config.getBoolean("caps-filter.enabled", true);
    }

    public int getMaxCapsPercentage() {
        return this.config.getInt("caps-filter.max-caps-percentage", 70);
    }

    public int getMinCapsLength() {
        return this.config.getInt("caps-filter.min-length", 4);
    }

    public CapsFilter getCapsFilter() {
        return new CapsFilter(this.isCapsFilterEnabled(), this.getMaxCapsPercentage(), this.getMinCapsLength());
    }

    public boolean isHoverEnabled() {
        return this.config.getBoolean("hover-text.enabled", true);
    }

    public List<String> getHoverFormat() {
        return this.config.getStringList("hover-text.format");
    }

    public HoverTextUtil getHoverTextUtil() {
        return new HoverTextUtil(this.getHoverFormat(), this.isHoverEnabled());
    }

    public boolean isAntiAdEnabled() {
        return this.config.getBoolean("anti-ad.enabled", true);
    }

    public float getAntiAdSensitivity() {
        return (float)this.config.getDouble("anti-ad.sensitivity", 0.7);
    }

    public List<String> getAntiAdWhitelistedUrls() {
        return this.config.getStringList("anti-ad.whitelisted-urls");
    }

    public boolean shouldNotifyStaffAboutAds() {
        return this.config.getBoolean("anti-ad.staff-notify", true);
    }

    public String getAntiAdPunishCommand() {
        return this.config.getString("anti-ad.punish-command", "ban %player_name% advertising");
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config", e);
        }
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public String getString(String path, String defaultValue) {
        return this.config.getString(path, defaultValue);
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public boolean contains(String path) {
        return this.config.contains(path);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    public Set<String> getKeys(boolean deep) {
        return this.config.getKeys(deep);
    }

    private List<String> readFileToList(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private List<String> readResourceToList(String resourcePath) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStream resource = this.plugin.getResource(resourcePath);
             BufferedReader reader = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private HashMap<Integer, FileLine> processFileLines(List<String> fileLines) {
        HashMap<Integer, FileLine> processedLines = new HashMap<Integer, FileLine>();
        int positions = 1;
        for (int i = 0; i < fileLines.size(); ++i) {
            String line = fileLines.get(i);
            if (this.isListContent(line)) continue;
            if (!line.isEmpty() && !this.isComment(line) && line.contains(":")) {
                String[] split = line.split(":");
                boolean isValue = split.length > 1 && !this.isComment(split[1]);
                boolean isHeader = split.length == 1 || this.isComment(split[1]);
                boolean isList = isHeader && i + 1 < fileLines.size() && this.isListContent(fileLines.get(i + 1));
                processedLines.put(positions, new FileLine(line, isValue, isHeader, isList));
                ++positions;
                continue;
            }
            processedLines.put(positions, new FileLine(line, false, false, false));
            ++positions;
        }
        return processedLines;
    }

    private void updateConfigIfNeeded() {
        YamlConfiguration savesConfig;
        File savesFile = new File(this.plugin.getDataFolder(), "saves.yml");
        if (!savesFile.exists()) {
            try {
                savesFile.getParentFile().mkdirs();
                savesFile.createNewFile();
                savesConfig = new YamlConfiguration();
            }
            catch (IOException e) {
                Bukkit.getLogger().log(Level.WARNING, "&#FFAFFB[nonchat] &cFailed to create saves.yml: {0}", e.getMessage());
                return;
            }
        } else {
            savesConfig = YamlConfiguration.loadConfiguration((File)savesFile);
        }
        String currentVersion = savesConfig.getString("version");
        String pluginVersion = this.plugin.getDescription().getVersion();
        boolean isUpdated = pluginVersion.equals(currentVersion);
        if (currentVersion == null || !currentVersion.equals(pluginVersion)) {
            savesConfig.set("version", (Object)pluginVersion);
            try {
                savesConfig.save(savesFile);
            }
            catch (IOException e) {
                Bukkit.getLogger().log(Level.WARNING, "&#FFAFFB[nonchat] &cCould not save saves.yml: {0}", e.getMessage());
            }
        }
        if (!isUpdated) {
            Bukkit.getLogger().log(Level.INFO, "&#FFAFFB[nonchat] &aPlugin version changed from {0} to {1}", new Object[]{currentVersion != null ? currentVersion : "unknown", pluginVersion});
            Bukkit.getLogger().log(Level.INFO, "&#FFAFFB[nonchat] &aChecking for configuration updates...");
            this.setupConfigFile(true);
        } else {
            this.setupConfigFile(false);
        }
    }

    private void setupConfigFile(boolean backup) {
        block33: {
            try {
                YamlConfiguration defaultConfig;
                if (backup) {
                    this.createBackup();
                }
                List<String> fileAsList = this.readFileToList(this.configFile);
                HashMap<Integer, FileLine> fileLines = this.processFileLines(fileAsList);
                YamlConfiguration currentConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
                try (InputStream resourceStream = this.plugin.getResource("config.yml");){
                    if (resourceStream == null) {
                        Bukkit.getLogger().log(Level.WARNING, "&#FFAFFB[nonchat] &cCould not load default config.yml from plugin resources!");
                        return;
                    }
                    defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
                }
                boolean hasChanges = false;
                for (String key : defaultConfig.getKeys(true)) {
                    if (currentConfig.contains(key) || defaultConfig.isConfigurationSection(key) || !this.shouldAddMissingKey(key, (FileConfiguration)currentConfig)) continue;
                    currentConfig.set(key, defaultConfig.get(key));
                    hasChanges = true;
                    Bukkit.getLogger().log(Level.INFO, "&#FFAFFB[nonchat] &aAdded missing configuration key: {0}", key);
                }
                if (!hasChanges) break block33;
                List<String> templateAsList = this.readResourceToList("config.yml");
                HashMap<Integer, FileLine> templateLines = this.processFileLines(templateAsList);
                StringBuilder builder = new StringBuilder();
                HashMap<Integer, String> headers = new HashMap<Integer, String>();
                int templatePositions = templateLines.size() + 1;
                for (int pos = 1; pos < templatePositions; ++pos) {
                    String header;
                    int i;
                    FileLine fileLine = templateLines.get(pos);
                    if (fileLine == null) continue;
                    String line = fileLine.getLine();
                    if (!(fileLine.isValue() || fileLine.isHeader() || fileLine.isList())) {
                        builder.append(line).append("\n");
                        continue;
                    }
                    int spaces = 0;
                    for (char c : line.toCharArray()) {
                        if (c != ' ') break;
                        ++spaces;
                    }
                    int point = spaces / 2;
                    String identifier = line.substring(spaces).split(":")[0];
                    if (fileLine.isHeader()) {
                        headers.put(point, identifier);
                    }
                    if (fileLine.isValue()) {
                        StringBuilder path = new StringBuilder();
                        for (i = 0; i <= point - 1; ++i) {
                            header = (String)headers.get(i);
                            if (header == null) continue;
                            path.append(header).append(".");
                        }
                        path.append(identifier);
                        for (i = 0; i < spaces; ++i) {
                            builder.append(" ");
                        }
                        builder.append(identifier).append(": ");
                        Object value = currentConfig.get(path.toString());
                        if (value instanceof String) {
                            String string = (String)value;
                            String stringValue = string.replace("\n", "\\n");
                            builder.append("\"").append(stringValue).append("\"\n");
                            continue;
                        }
                        builder.append(value).append("\n");
                        continue;
                    }
                    if (fileLine.isList()) {
                        StringBuilder path = new StringBuilder();
                        for (i = 0; i <= point - 1; ++i) {
                            header = (String)headers.get(i);
                            if (header == null) continue;
                            path.append(header).append(".");
                        }
                        path.append(identifier);
                        for (i = 0; i < spaces; ++i) {
                            builder.append(" ");
                        }
                        builder.append(identifier).append(":");
                        List value = currentConfig.getStringList(path.toString());
                        if (value.isEmpty()) {
                            builder.append(" []\n");
                            continue;
                        }
                        builder.append("\n");
                        for (String listLine : value) {
                            for (int i2 = 0; i2 < spaces + 2; ++i2) {
                                builder.append(" ");
                            }
                            String escapedListLine = listLine.replace("\n", "\\n");
                            boolean useSingleQuotes = escapedListLine.contains("\\");
                            String quote = useSingleQuotes ? "'" : "\"";
                            builder.append("- ").append(quote).append(escapedListLine).append(quote).append("\n");
                        }
                        continue;
                    }
                    builder.append(line).append("\n");
                }
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));){
                    writer.write(builder.toString());
                    writer.flush();
                }
                this.plugin.logResponse("Configuration updated successfully with new options");
                if (backup) {
                    this.plugin.logResponse("A backup of your previous configuration was created in the 'backups' folder.");
                }
            }
            catch (IOException e) {
                this.plugin.logError("Failed to update configuration: " + e.getMessage());
            }
        }
    }

    private void createBackup() {
        try {
            File backupDir = new File(this.plugin.getDataFolder(), "backups");
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String timestamp = dateFormat.format(new Date());
            File backupFile = new File(backupDir, "config_" + timestamp + ".yml.backup");
            try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
                 BufferedWriter writer = new BufferedWriter(new FileWriter(backupFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            this.plugin.logResponse("Created configuration backup: " + backupFile.getName());
        }
        catch (IOException e) {
            this.plugin.logError("Failed to create configuration backup: " + e.getMessage());
        }
    }

    private boolean shouldAddMissingKey(String key, FileConfiguration currentConfig) {
        if (!key.contains(".")) {
            return true;
        }
        String[] parts = key.split("\\.");
        String topLevelSection = parts[0];
        if (!this.hasAnyKeysInSection(currentConfig, topLevelSection)) {
            return true;
        }
        return true;
    }

    private boolean hasAnyKeysInSection(FileConfiguration config, String sectionName) {
        if (!config.contains(sectionName)) {
            return false;
        }
        Set allKeys = config.getKeys(true);
        for (String existingKey : allKeys) {
            if (!existingKey.startsWith(sectionName + ".") && !existingKey.equals(sectionName)) continue;
            return true;
        }
        return false;
    }

    private boolean isComment(String s) {
        return s.replace(" ", "").startsWith("#");
    }

    private boolean isListContent(String s) {
        return s.replace(" ", "").startsWith("-");
    }

    @Generated
    public Nonchat getPlugin() {
        return this.plugin;
    }

    @Generated
    public File getConfigFile() {
        return this.configFile;
    }

    @Generated
    public FileConfiguration getConfig() {
        return this.config;
    }

    private static class FileLine {
        private final String line;
        private final boolean isValue;
        private final boolean isHeader;
        private final boolean isList;

        public FileLine(String line, boolean isValue, boolean isHeader, boolean isList) {
            this.line = line;
            this.isValue = isValue;
            this.isHeader = isHeader;
            this.isList = isList;
        }

        public String getLine() {
            return this.line;
        }

        public boolean isValue() {
            return this.isValue;
        }

        public boolean isHeader() {
            return this.isHeader;
        }

        public boolean isList() {
            return this.isList;
        }
    }
}

