/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.listener;

import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class DeathCoordinates
implements Listener {
    private final PluginConfig config;
    private final PluginMessages messages;

    public DeathCoordinates(PluginConfig config, PluginMessages messages) {
        this.config = config;
        this.messages = messages;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        Location deathLoc = player.getLocation();
        World.Environment dimension = deathLoc.getWorld().getEnvironment();
        if (this.config.isShowDeathCoordinatesEnabled()) {
            String coordsMessage = String.format(this.messages.getString("death-coordinates"), this.formatDimension(dimension), deathLoc.getBlockX(), deathLoc.getBlockY(), deathLoc.getBlockZ());
            player.sendMessage(ColorUtil.parseComponent(coordsMessage));
        }
    }

    private String formatDimension(World.Environment dimension) {
        return switch (dimension) {
            case World.Environment.NORMAL -> this.messages.getString("dimension-overworld");
            case World.Environment.NETHER -> this.messages.getString("dimension-nether");
            case World.Environment.THE_END -> this.messages.getString("dimension-end");
            default -> dimension.toString();
        };
    }
}

