/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.service;

import com.nonxedy.nonchat.api.IMessageHandler;
import com.nonxedy.nonchat.command.impl.IgnoreCommand;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.core.BroadcastManager;
import com.nonxedy.nonchat.core.ChatManager;
import com.nonxedy.nonchat.core.MessageManager;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatService
implements IMessageHandler {
    private final ChatManager chatManager;
    private final MessageManager messageManager;
    private final BroadcastManager broadcastManager;
    private final PluginConfig config;
    private IgnoreCommand ignoreCommand;

    public ChatService(ChatManager chatManager, MessageManager messageManager, BroadcastManager broadcastManager, PluginConfig config) {
        this.chatManager = chatManager;
        this.messageManager = messageManager;
        this.broadcastManager = broadcastManager;
        this.config = config;
    }

    @Override
    public void handleChat(Player player, String message) {
        this.chatManager.processChat(player, message);
    }

    @Override
    public void handlePrivateMessage(Player sender, Player receiver, String message) {
        if (this.ignoreCommand != null) {
            if (this.ignoreCommand.isIgnoring(receiver, sender)) {
                if (this.config.isUndeliveredMessageNotificationEnabled()) {
                    // empty if block
                }
                return;
            }
            if (this.ignoreCommand.isIgnoring(sender, receiver)) {
                return;
            }
        }
        this.messageManager.sendPrivateMessage(sender, receiver, message);
    }

    @Override
    public void handleBroadcast(CommandSender sender, String message) {
        this.broadcastManager.broadcast(sender, message);
    }

    @Override
    public void handleStaffChat(Player sender, String message) {
        if (!sender.hasPermission("nonchat.color") && ColorUtil.hasColorCodes(message)) {
            String strippedMessage = ColorUtil.stripAllColors(message);
            this.chatManager.processChat(sender, "@" + strippedMessage);
        } else {
            this.chatManager.processChat(sender, "@" + message);
        }
    }

    public void setIgnoreCommand(IgnoreCommand ignoreCommand) {
        this.ignoreCommand = ignoreCommand;
    }
}

