/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.service;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.IConfigurable;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.lang.LanguageManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class ConfigService
implements IConfigurable {
    private final Nonchat plugin;
    private final PluginConfig config;
    private final PluginMessages messages;
    private final LanguageManager languageManager;

    public ConfigService(Nonchat plugin) {
        this.plugin = plugin;
        this.config = new PluginConfig(plugin);
        this.languageManager = new LanguageManager(plugin.getDataFolder());
        this.messages = new PluginMessages(plugin);
        this.load();
        this.messages.loadLanguage();
    }

    @Override
    public void load() {
        this.config.loadConfig();
        this.messages.loadLanguage();
    }

    @Override
    public void save() {
        this.config.saveConfig();
    }

    @Override
    public void reload() {
        this.config.reloadConfig();
        this.messages.reloadConfig();
    }

    public PluginConfig getConfig() {
        return this.config;
    }

    public PluginMessages getMessages() {
        return this.messages;
    }

    public String getMessage(String key) {
        return this.messages.getString(key);
    }

    public void logCommand(String command, String[] args) {
        if (this.config.isDebug()) {
            this.plugin.logCommand(command, args);
        }
    }

    public void logError(String error) {
        if (this.config.isDebug()) {
            this.plugin.logError(error);
        }
    }

    @Override
    public String getString(String path) {
        return this.config.getString(path);
    }

    @Override
    public String getString(String path, String defaultValue) {
        return this.config.getString(path, defaultValue);
    }

    @Override
    public int getInt(String path) {
        return this.config.getInt(path);
    }

    @Override
    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    @Override
    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    @Override
    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    @Override
    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    @Override
    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    @Override
    public boolean contains(String path) {
        return this.config.contains(path);
    }

    @Override
    public ConfigurationSection getSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        return this.config.getKeys(deep);
    }

    @Override
    public boolean isUndeliveredMessageNotificationEnabled() {
        return this.config.isUndeliveredMessageNotificationEnabled();
    }

    @Override
    public void setUndeliveredMessageNotificationEnabled(boolean enabled) {
        this.config.setUndeliveredMessageNotificationEnabled(enabled);
    }

    public boolean isInteractivePlaceholdersEnabled() {
        return this.config.isInteractivePlaceholdersEnabled();
    }

    public void setInteractivePlaceholdersEnabled(boolean enabled) {
        this.config.setInteractivePlaceholdersEnabled(enabled);
    }

    public Map<String, ConfigurationSection> getCustomPlaceholders() {
        return this.config.getCustomPlaceholders();
    }

    public boolean isCustomPlaceholderEnabled(String placeholderKey) {
        return this.config.isCustomPlaceholderEnabled(placeholderKey);
    }

    public String getCustomPlaceholderActivation(String placeholderKey) {
        return this.config.getCustomPlaceholderActivation(placeholderKey);
    }

    public String getCustomPlaceholderDisplayName(String placeholderKey) {
        return this.config.getCustomPlaceholderDisplayName(placeholderKey);
    }

    public String getCustomPlaceholderFormat(String placeholderKey) {
        return this.config.getCustomPlaceholderFormat(placeholderKey);
    }

    public String getCustomPlaceholderPermission(String placeholderKey) {
        return this.config.getCustomPlaceholderPermission(placeholderKey);
    }

    public List<String> getCustomPlaceholderHoverText(String placeholderKey) {
        return this.config.getCustomPlaceholderHoverText(placeholderKey);
    }

    public String getCustomPlaceholderClickActionType(String placeholderKey) {
        return this.config.getCustomPlaceholderClickActionType(placeholderKey);
    }

    public String getCustomPlaceholderClickActionValue(String placeholderKey) {
        return this.config.getCustomPlaceholderClickActionValue(placeholderKey);
    }
}

