/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginConfig;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AsyncConfigSaver {
    private final BlockingQueue<ConfigSaveTask> saveQueue = new LinkedBlockingQueue<ConfigSaveTask>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r, "nonchat-config-saver");
        thread.setDaemon(true);
        return thread;
    });
    private final PluginConfig config;
    private final Nonchat plugin;

    public AsyncConfigSaver(Nonchat plugin, PluginConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.scheduler.scheduleWithFixedDelay(this::processBatch, 5L, 5L, TimeUnit.SECONDS);
    }

    public void saveAsync(String path, Object value) {
        try {
            this.saveQueue.offer(new ConfigSaveTask(path, value));
        }
        catch (Exception e) {
            this.plugin.logError("Failed to queue config save for path: " + path + ", error: " + e.getMessage());
            try {
                this.config.set(path, value);
                this.config.saveConfig();
            }
            catch (Exception saveError) {
                this.plugin.logError("Fallback config save also failed for path: " + path + ", error: " + saveError.getMessage());
            }
        }
    }

    public void saveNow() {
        this.processBatch();
    }

    private void processBatch() {
        block7: {
            ArrayList batch = new ArrayList();
            this.saveQueue.drainTo(batch);
            if (batch.isEmpty()) {
                return;
            }
            try {
                for (ConfigSaveTask task : batch) {
                    this.config.set(task.path, task.value);
                }
                this.config.saveConfig();
                if (!this.plugin.getConfigService().getConfig().isDebug()) break block7;
                this.plugin.logResponse("Saved " + batch.size() + " configuration changes");
            }
            catch (Exception e) {
                this.plugin.logError("Failed to save config batch: " + e.getMessage());
                for (ConfigSaveTask task : batch) {
                    try {
                        this.config.set(task.path, task.value);
                        this.config.saveConfig();
                    }
                    catch (Exception individualError) {
                        this.plugin.logError("Failed to save individual config change for path: " + task.path + ", error: " + individualError.getMessage());
                    }
                }
            }
        }
    }

    public void shutdown() {
        this.saveNow();
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class ConfigSaveTask {
        final String path;
        final Object value;

        ConfigSaveTask(String path, Object value) {
            this.path = path;
            this.value = value;
        }
    }
}

