/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util;

import com.nonxedy.nonchat.api.InteractivePlaceholder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InteractivePlaceholderManager {
    private final Map<String, InteractivePlaceholder> placeholders = new HashMap<String, InteractivePlaceholder>();
    private final Pattern placeholderPattern = Pattern.compile("\\[([\\w]+)(?::([^\\]]*))?\\]", 2);

    public void registerPlaceholder(@NotNull InteractivePlaceholder placeholder) {
        this.placeholders.put(placeholder.getPlaceholder().toLowerCase(), placeholder);
    }

    public void unregisterPlaceholder(@NotNull String placeholderName) {
        this.placeholders.remove(placeholderName.toLowerCase());
    }

    @Nullable
    public InteractivePlaceholder getPlaceholder(@NotNull String placeholderName) {
        return this.placeholders.get(placeholderName.toLowerCase());
    }

    public boolean isPlaceholderRegistered(@NotNull String placeholderName) {
        return this.placeholders.containsKey(placeholderName.toLowerCase());
    }

    @NotNull
    public Component processMessage(@NotNull Player player, @NotNull String message) {
        if (message.isEmpty()) {
            return Component.text((String)message);
        }
        TextComponent.Builder builder = Component.text().content("");
        Matcher matcher = this.placeholderPattern.matcher(message);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                String textBefore = message.substring(lastEnd, matcher.start());
                builder.append((Component)Component.text((String)textBefore));
            }
            String placeholderName = matcher.group(1).toLowerCase();
            String arguments = matcher.group(2);
            InteractivePlaceholder placeholder = this.getPlaceholder(placeholderName);
            if (placeholder != null && placeholder.isEnabled()) {
                String permission = placeholder.getPermission();
                if (permission == null || permission.isEmpty() || player.hasPermission(permission)) {
                    String[] args = arguments != null ? arguments.split(":") : new String[]{};
                    Component placeholderComponent = placeholder.process(player, args);
                    builder.append(placeholderComponent);
                } else {
                    builder.append((Component)Component.text((String)matcher.group()));
                }
            } else {
                builder.append((Component)Component.text((String)matcher.group()));
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < message.length()) {
            String remainingText = message.substring(lastEnd);
            builder.append((Component)Component.text((String)remainingText));
        }
        return builder.build();
    }

    @NotNull
    public Map<String, InteractivePlaceholder> getAllPlaceholders() {
        return new HashMap<String, InteractivePlaceholder>(this.placeholders);
    }

    public void clearPlaceholders() {
        this.placeholders.clear();
    }
}

