/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.filters;

import com.nonxedy.nonchat.api.MessageFilter;
import com.nonxedy.nonchat.config.PluginConfig;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdDetector
implements MessageFilter {
    private static final Pattern pattern = Pattern.compile("([\\w+]+://)?([\\w-]+\\.)*[\\w-]+[.:]\\w+([/?=&#.]?[\\w-]+)*/?", 2);
    private final List<String> whitelistedUrls;
    private final float sensitivity;
    private final String punishCommand;

    public AdDetector(PluginConfig config, float sensitivity, String punishCommand) {
        this.whitelistedUrls = config.getAntiAdWhitelistedUrls();
        this.sensitivity = Math.max(0.0f, Math.min(1.0f, sensitivity));
        this.punishCommand = punishCommand;
    }

    @Override
    public boolean shouldFilter(Player player, String message) {
        if (player.hasPermission("nonchat.ad.bypass")) {
            return false;
        }
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String matched = matcher.group();
            if (this.isWhitelisted(matched)) continue;
            this.notifyStaff(player, message);
            return true;
        }
        if (this.sensitivity > 0.5f && this.detectCommonAdTerms(message)) {
            this.notifyStaff(player, message);
            return true;
        }
        return false;
    }

    private boolean isWhitelisted(String url) {
        for (String whitelisted : this.whitelistedUrls) {
            if (!url.equals(whitelisted)) continue;
            return true;
        }
        return false;
    }

    private boolean detectCommonAdTerms(String message) {
        String lower = message.toLowerCase();
        return lower.contains("join") && lower.contains("server") || lower.contains("ip") && lower.contains("play");
    }

    private String resolvePlaceholders(Player player, String text) {
        if (player == null) {
            return text;
        }
        try {
            Class.forName("me.clip.placeholderapi.PlaceholderAPI");
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        catch (ClassNotFoundException e) {
            return text.replace("%player_name%", player.getName()).replace("%player_uuid%", player.getUniqueId().toString());
        }
    }

    private void notifyStaff(Player player, String message) {
        String notification = String.format("\u00a7#FFAFFB[nonchat] \u00a7f%s posted advertisement: \u00a7#ff0000%s", player.getName(), message);
        Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("nonchat.ad.notify") || p.isOp()).forEach(p -> p.sendMessage(notification));
        Bukkit.getConsoleSender().sendMessage(notification);
        if (this.punishCommand != null && !this.punishCommand.isEmpty()) {
            String resolvedCommand = this.resolvePlaceholders(player, this.punishCommand);
            try {
                Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("nonchat"), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)resolvedCommand));
            }
            catch (IllegalArgumentException e) {
                Bukkit.getLogger().log(Level.WARNING, "&#FFAFFB[nonchat] &cFailed to execute punish command: {0}", e.getMessage());
            }
        }
    }
}

