/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.formatting;

import lombok.Generated;

public class ChatTypeUtil {
    private final boolean enabled;
    private final String displayName;
    private final String format;
    private final int radius;
    private final char chatChar;
    private final String sendPermission;
    private final String receivePermission;
    private final int cooldown;
    private final int minLength;
    private final int maxLength;

    public ChatTypeUtil(boolean enabled, String format, int radius, char chatChar, String permission) {
        this(enabled, null, format, radius, chatChar, permission, null, 0, 0, -1);
    }

    public ChatTypeUtil(boolean enabled, String displayName, String format, int radius, char chatChar, String sendPermission, String receivePermission, int cooldown, int minLength, int maxLength) {
        this.enabled = enabled;
        this.displayName = displayName != null ? displayName : "Channel";
        this.format = format;
        this.radius = radius;
        this.chatChar = chatChar;
        this.sendPermission = sendPermission;
        this.receivePermission = receivePermission;
        this.cooldown = cooldown;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Deprecated
    public String getPermission() {
        return this.sendPermission;
    }

    @Deprecated
    public boolean hasPermission() {
        return this.hasSendPermission();
    }

    public boolean hasSendPermission() {
        return this.sendPermission != null && !this.sendPermission.isEmpty();
    }

    public boolean hasReceivePermission() {
        return this.receivePermission != null && !this.receivePermission.isEmpty();
    }

    public boolean hasCooldown() {
        return this.cooldown > 0;
    }

    public boolean hasMinLength() {
        return this.minLength > 0;
    }

    public boolean hasMaxLength() {
        return this.maxLength >= 0;
    }

    public boolean isGlobal() {
        return this.radius == -1;
    }

    @Generated
    public static ChatTypeUtilBuilder builder() {
        return new ChatTypeUtilBuilder();
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public int getRadius() {
        return this.radius;
    }

    @Generated
    public char getChatChar() {
        return this.chatChar;
    }

    @Generated
    public String getSendPermission() {
        return this.sendPermission;
    }

    @Generated
    public String getReceivePermission() {
        return this.receivePermission;
    }

    @Generated
    public int getCooldown() {
        return this.cooldown;
    }

    @Generated
    public int getMinLength() {
        return this.minLength;
    }

    @Generated
    public int getMaxLength() {
        return this.maxLength;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatTypeUtil)) {
            return false;
        }
        ChatTypeUtil other = (ChatTypeUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getRadius() != other.getRadius()) {
            return false;
        }
        if (this.getChatChar() != other.getChatChar()) {
            return false;
        }
        if (this.getCooldown() != other.getCooldown()) {
            return false;
        }
        if (this.getMinLength() != other.getMinLength()) {
            return false;
        }
        if (this.getMaxLength() != other.getMaxLength()) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$sendPermission = this.getSendPermission();
        String other$sendPermission = other.getSendPermission();
        if (this$sendPermission == null ? other$sendPermission != null : !this$sendPermission.equals(other$sendPermission)) {
            return false;
        }
        String this$receivePermission = this.getReceivePermission();
        String other$receivePermission = other.getReceivePermission();
        return !(this$receivePermission == null ? other$receivePermission != null : !this$receivePermission.equals(other$receivePermission));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatTypeUtil;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getRadius();
        result = result * 59 + this.getChatChar();
        result = result * 59 + this.getCooldown();
        result = result * 59 + this.getMinLength();
        result = result * 59 + this.getMaxLength();
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $sendPermission = this.getSendPermission();
        result = result * 59 + ($sendPermission == null ? 43 : $sendPermission.hashCode());
        String $receivePermission = this.getReceivePermission();
        result = result * 59 + ($receivePermission == null ? 43 : $receivePermission.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChatTypeUtil(enabled=" + this.isEnabled() + ", displayName=" + this.getDisplayName() + ", format=" + this.getFormat() + ", radius=" + this.getRadius() + ", chatChar=" + this.getChatChar() + ", sendPermission=" + this.getSendPermission() + ", receivePermission=" + this.getReceivePermission() + ", cooldown=" + this.getCooldown() + ", minLength=" + this.getMinLength() + ", maxLength=" + this.getMaxLength() + ")";
    }

    @Generated
    public static class ChatTypeUtilBuilder {
        @Generated
        private boolean enabled;
        @Generated
        private String displayName;
        @Generated
        private String format;
        @Generated
        private int radius;
        @Generated
        private char chatChar;
        @Generated
        private String sendPermission;
        @Generated
        private String receivePermission;
        @Generated
        private int cooldown;
        @Generated
        private int minLength;
        @Generated
        private int maxLength;

        @Generated
        ChatTypeUtilBuilder() {
        }

        @Generated
        public ChatTypeUtilBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public ChatTypeUtilBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Generated
        public ChatTypeUtilBuilder format(String format) {
            this.format = format;
            return this;
        }

        @Generated
        public ChatTypeUtilBuilder radius(int radius) {
            this.radius = radius;
            return this;
        }

        @Generated
        public ChatTypeUtilBuilder chatChar(char chatChar) {
            this.chatChar = chatChar;
            return this;
        }

        @Generated
        public ChatTypeUtilBuilder sendPermission(String sendPermission) {
            this.sendPermission = sendPermission;
            return this;
        }

        @Generated
        public ChatTypeUtilBuilder receivePermission(String receivePermission) {
            this.receivePermission = receivePermission;
            return this;
        }

        @Generated
        public ChatTypeUtilBuilder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        @Generated
        public ChatTypeUtilBuilder minLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        @Generated
        public ChatTypeUtilBuilder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        @Generated
        public ChatTypeUtil build() {
            return new ChatTypeUtil(this.enabled, this.displayName, this.format, this.radius, this.chatChar, this.sendPermission, this.receivePermission, this.cooldown, this.minLength, this.maxLength);
        }

        @Generated
        public String toString() {
            return "ChatTypeUtil.ChatTypeUtilBuilder(enabled=" + this.enabled + ", displayName=" + this.displayName + ", format=" + this.format + ", radius=" + this.radius + ", chatChar=" + this.chatChar + ", sendPermission=" + this.sendPermission + ", receivePermission=" + this.receivePermission + ", cooldown=" + this.cooldown + ", minLength=" + this.minLength + ", maxLength=" + this.maxLength + ")";
        }
    }
}

