/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.formatting;

import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.integration.external.IntegrationUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.entity.Player;

public class PrivateMessageUtil {
    public static Component createSenderMessage(PluginConfig config, Player sender, Player target, String message) {
        String format = config.getPrivateChatSenderFormat();
        String senderName = sender != null ? sender.getName() : "Console";
        String formattedMessage = format.replace("{sender}", senderName).replace("{receiver}", target.getName()).replace("{message}", message);
        if (sender != null) {
            formattedMessage = IntegrationUtil.processPlaceholders(sender, formattedMessage);
        }
        Component baseComponent = ColorUtil.parseComponent(formattedMessage);
        if (config.isPrivateChatSenderHoverEnabled()) {
            baseComponent = PrivateMessageUtil.addSenderInteractivity(config, baseComponent, sender, target);
        }
        return baseComponent;
    }

    public static Component createReceiverMessage(PluginConfig config, Player sender, Player target, String message) {
        String format = config.getPrivateChatReceiverFormat();
        String senderName = sender != null ? sender.getName() : "Console";
        String formattedMessage = format.replace("{sender}", senderName).replace("{receiver}", target.getName()).replace("{message}", message);
        formattedMessage = IntegrationUtil.processPlaceholders(target, formattedMessage);
        Component baseComponent = ColorUtil.parseComponent(formattedMessage);
        if (config.isPrivateChatReceiverHoverEnabled()) {
            baseComponent = PrivateMessageUtil.addReceiverInteractivity(config, baseComponent, sender, target);
        }
        return baseComponent;
    }

    private static Component addSenderInteractivity(PluginConfig config, Component component, Player sender, Player target) {
        List<String> hoverLines = config.getPrivateChatSenderHover();
        if (hoverLines.isEmpty()) {
            return component;
        }
        Component hoverComponent = PrivateMessageUtil.buildHoverText(hoverLines, sender, target);
        Component resultComponent = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent));
        if (config.isPrivateChatClickActionsEnabled()) {
            String clickCommand = config.getPrivateChatReplyCommand().replace("{sender}", sender != null ? sender.getName() : "Console").replace("{receiver}", target.getName());
            ClickEvent clickEvent = ClickEvent.suggestCommand((String)clickCommand);
            resultComponent = resultComponent.clickEvent(clickEvent);
        }
        return resultComponent;
    }

    private static Component addReceiverInteractivity(PluginConfig config, Component component, Player sender, Player target) {
        List<String> hoverLines = config.getPrivateChatReceiverHover();
        if (hoverLines.isEmpty()) {
            return component;
        }
        Component hoverComponent = PrivateMessageUtil.buildHoverText(hoverLines, sender, target);
        Component resultComponent = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent));
        if (config.isPrivateChatClickActionsEnabled()) {
            String clickCommand = config.getPrivateChatReplyCommand().replace("{sender}", sender != null ? sender.getName() : "Console").replace("{receiver}", target.getName());
            ClickEvent clickEvent = ClickEvent.suggestCommand((String)clickCommand);
            resultComponent = resultComponent.clickEvent(clickEvent);
        }
        return resultComponent;
    }

    private static Component buildHoverText(List<String> hoverLines, Player sender, Player target) {
        TextComponent.Builder builder = Component.text();
        String currentTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        for (int i = 0; i < hoverLines.size(); ++i) {
            String line = hoverLines.get(i);
            String senderName = sender != null ? sender.getName() : "Console";
            line = line.replace("{sender}", senderName).replace("{receiver}", target.getName()).replace("{time}", currentTime);
            line = sender != null ? IntegrationUtil.processPlaceholders(sender, line) : IntegrationUtil.processPlaceholders(target, line);
            Component lineComponent = ColorUtil.parseComponent(line);
            builder.append(lineComponent);
            if (i >= hoverLines.size() - 1) continue;
            builder.append((Component)Component.newline());
        }
        return builder.build();
    }
}

