/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.packets;

import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;

public class DisplayEntityUtil {
    private static final int MAX_LINE_LENGTH = 40;
    private static final double LINE_SPACING = 0.25;
    private static final ObjectPool<TextDisplay> displayPool = new ObjectPool(50);

    public static List<TextDisplay> spawnMultilineBubble(Player player, String text, Location location, double scale) {
        return DisplayEntityUtil.spawnMultilineBubble(player, text, location, scale, scale, scale, scale);
    }

    public static List<TextDisplay> spawnMultilineBubble(Player player, String text, Location location, double overallScale, double scaleX, double scaleY, double scaleZ) {
        List<String> lines = DisplayEntityUtil.splitTextIntoLines(text, 40);
        ArrayList<TextDisplay> bubbleDisplays = new ArrayList<TextDisplay>();
        for (int i = 0; i < lines.size(); ++i) {
            Location lineLocation = location.clone().add(0.0, (double)(lines.size() - 1 - i) * 0.25, 0.0);
            TextDisplay bubble = displayPool.acquire(() -> {
                try {
                    World world = player.getWorld();
                    TextDisplay display = (TextDisplay)world.spawnEntity(lineLocation, EntityType.TEXT_DISPLAY);
                    DisplayEntityUtil.configureTextDisplay(display, overallScale, scaleX, scaleY, scaleZ);
                    return display;
                }
                catch (Exception e) {
                    Bukkit.getLogger().log(Level.WARNING, "[nonchat] Failed to spawn text display: {0}", e.getMessage());
                    return null;
                }
            });
            if (bubble == null) continue;
            try {
                bubble.teleport(lineLocation);
                Component component = ColorUtil.parseComponent(lines.get(i));
                bubble.text(component);
                bubbleDisplays.add(bubble);
                continue;
            }
            catch (Exception e) {
                if (bubble != null && !bubble.isDead()) {
                    bubble.remove();
                }
                Bukkit.getLogger().log(Level.WARNING, "[nonchat] Failed to configure text display: {0}", e.getMessage());
            }
        }
        return bubbleDisplays;
    }

    private static void configureTextDisplay(TextDisplay display, double scale) {
        DisplayEntityUtil.configureTextDisplay(display, scale, scale, scale, scale);
    }

    private static void configureTextDisplay(TextDisplay display, double overallScale, double scaleX, double scaleY, double scaleZ) {
        try {
            display.setCustomNameVisible(false);
            display.setGravity(false);
            display.setInvulnerable(true);
            display.setSilent(true);
            Vector3f scaleVector = new Vector3f((float)(overallScale * scaleX), (float)(overallScale * scaleY), (float)(overallScale * scaleZ));
            Transformation transformation = display.getTransformation();
            transformation.getScale().set(scaleVector.x, scaleVector.y, scaleVector.z);
            display.setTransformation(transformation);
            display.setBackgroundColor(Color.BLACK);
            display.setAlignment(TextDisplay.TextAlignment.CENTER);
            display.setLineWidth(200);
            display.setShadowed(true);
            display.setSeeThrough(true);
            display.setDefaultBackground(false);
            display.setBillboard(Display.Billboard.CENTER);
            display.setViewRange(48.0f);
            display.setInterpolationDuration(0);
            display.setTeleportDuration(0);
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.FINE, "[nonchat] Error configuring text display: {0}", e.getMessage());
        }
    }

    public static TextDisplay spawnBubble(Player player, String text, Location location, double scale) {
        TextDisplay bubble = displayPool.acquire(() -> {
            try {
                World world = player.getWorld();
                TextDisplay display = (TextDisplay)world.spawnEntity(location, EntityType.TEXT_DISPLAY);
                DisplayEntityUtil.configureTextDisplay(display, scale);
                return display;
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "[nonchat] Failed to spawn text display: {0}", e.getMessage());
                return null;
            }
        });
        if (bubble == null) {
            return null;
        }
        try {
            Component component = ColorUtil.parseComponent(text);
            bubble.text(component);
            bubble.teleport(location);
        }
        catch (Exception e) {
            if (bubble != null && !bubble.isDead()) {
                bubble.remove();
            }
            Bukkit.getLogger().log(Level.WARNING, "[nonchat] Failed to configure text display: {0}", e.getMessage());
            return null;
        }
        return bubble;
    }

    public static void removeBubble(TextDisplay bubble) {
        try {
            if (bubble != null && !bubble.isDead()) {
                bubble.remove();
                displayPool.release(bubble);
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.FINE, "[nonchat] Error removing text display: {0}", e.getMessage());
        }
    }

    public static void removeBubbles(List<TextDisplay> bubbles) {
        try {
            if (bubbles != null) {
                bubbles.forEach(DisplayEntityUtil::removeBubble);
                bubbles.clear();
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.FINE, "[nonchat] Error removing text displays: {0}", e.getMessage());
        }
    }

    public static void updateBubbleLocation(TextDisplay bubble, Location location) {
        try {
            if (bubble != null && !bubble.isDead()) {
                bubble.teleport(location);
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.FINE, "[nonchat] Error updating text display location: {0}", e.getMessage());
        }
    }

    public static void updateBubblesLocation(List<TextDisplay> bubbles, Location baseLocation) {
        try {
            if (bubbles != null) {
                bubbles.removeIf(bubble -> bubble == null || bubble.isDead());
                for (int i = 0; i < bubbles.size(); ++i) {
                    try {
                        TextDisplay bubble2 = bubbles.get(i);
                        if (bubble2 == null || bubble2.isDead()) continue;
                        Location lineLocation = baseLocation.clone().add(0.0, (double)(bubbles.size() - 1 - i) * 0.25, 0.0);
                        bubble2.teleport(lineLocation);
                        continue;
                    }
                    catch (Exception e) {
                        Bukkit.getLogger().log(Level.FINE, "[nonchat] Error updating text display {0} location: {1}", new Object[]{i, e.getMessage()});
                    }
                }
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.FINE, "[nonchat] Error updating text displays location: {0}", e.getMessage());
        }
    }

    private static List<String> splitTextIntoLines(String text, int maxLength) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            String[] words = text.split(" ");
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                String lineWithoutColors;
                int currentVisibleLength;
                String wordWithoutColors = ColorUtil.stripAllColors(word);
                int visibleLength = wordWithoutColors.length();
                if (currentVisibleLength + visibleLength + ((currentVisibleLength = (lineWithoutColors = ColorUtil.stripAllColors(currentLine.toString())).length()) > 0 ? 1 : 0) <= maxLength) {
                    if (currentLine.length() > 0) {
                        currentLine.append(" ");
                    }
                    currentLine.append(word);
                    continue;
                }
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder();
                }
                if (visibleLength > maxLength) {
                    String remainingWord = word;
                    while (ColorUtil.stripAllColors(remainingWord).length() > maxLength) {
                        int splitPos = DisplayEntityUtil.findBestSplitPosition(remainingWord, maxLength);
                        lines.add(remainingWord.substring(0, splitPos));
                        remainingWord = remainingWord.substring(splitPos);
                    }
                    currentLine.append(remainingWord);
                    continue;
                }
                currentLine.append(word);
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
            }
            if (lines.isEmpty()) {
                lines.add(text);
            }
            return lines;
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.WARNING, "[nonchat] Error splitting text into lines: {0}", e.getMessage());
            ArrayList<String> fallback = new ArrayList<String>();
            fallback.add(text);
            return fallback;
        }
    }

    private static int findBestSplitPosition(String word, int maxLength) {
        try {
            int visibleChars = 0;
            for (int i = 0; i < word.length(); ++i) {
                if (word.charAt(i) == '\u00a7' && i + 1 < word.length()) {
                    ++i;
                    continue;
                }
                if (i + 2 < word.length() && word.charAt(i) == '&' && word.charAt(i + 1) == '#') {
                    i += 7;
                    continue;
                }
                if (++visibleChars < maxLength) continue;
                return i + 1;
            }
            return word.length();
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.FINE, "[nonchat] Error finding split position: {0}", e.getMessage());
            return Math.min(maxLength, word.length());
        }
    }

    public static void updateBubblesScale(List<TextDisplay> bubbles, double overallScale, double scaleX, double scaleY, double scaleZ) {
        try {
            if (bubbles != null) {
                bubbles.removeIf(bubble -> bubble == null || bubble.isDead());
                for (int i = 0; i < bubbles.size(); ++i) {
                    try {
                        TextDisplay bubble2 = bubbles.get(i);
                        if (bubble2 == null || bubble2.isDead()) continue;
                        Vector3f scaleVector = new Vector3f((float)(overallScale * scaleX), (float)(overallScale * scaleY), (float)(overallScale * scaleZ));
                        Transformation transformation = bubble2.getTransformation();
                        transformation.getScale().set(scaleVector.x, scaleVector.y, scaleVector.z);
                        bubble2.setTransformation(transformation);
                        continue;
                    }
                    catch (Exception e) {
                        Bukkit.getLogger().log(Level.FINE, "[nonchat] Error updating text display {0} scale: {1}", new Object[]{i, e.getMessage()});
                    }
                }
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.FINE, "[nonchat] Error updating text displays scale: {0}", e.getMessage());
        }
    }

    public static void updateBubbleScale(TextDisplay bubble, double overallScale, double scaleX, double scaleY, double scaleZ) {
        try {
            if (bubble != null && !bubble.isDead()) {
                Vector3f scaleVector = new Vector3f((float)(overallScale * scaleX), (float)(overallScale * scaleY), (float)(overallScale * scaleZ));
                Transformation transformation = bubble.getTransformation();
                transformation.getScale().set(scaleVector.x, scaleVector.y, scaleVector.z);
                bubble.setTransformation(transformation);
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.FINE, "[nonchat] Error updating text display scale: {0}", e.getMessage());
        }
    }

    public static void clearPool() {
        try {
            displayPool.clear();
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.FINE, "[nonchat] Error clearing text display pool: {0}", e.getMessage());
        }
    }

    private static class ObjectPool<T> {
        private final List<T> pool = new ArrayList<T>();
        private final int maxSize;

        public ObjectPool(int maxSize) {
            this.maxSize = maxSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T acquire(Supplier<T> creator) {
            try {
                List<T> list = this.pool;
                synchronized (list) {
                    if (!this.pool.isEmpty()) {
                        TextDisplay display;
                        T obj = this.pool.remove(this.pool.size() - 1);
                        if (obj instanceof TextDisplay && (display = (TextDisplay)obj).isDead()) {
                            return creator.get();
                        }
                        return obj;
                    }
                }
                return creator.get();
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.FINE, "[nonchat] Error acquiring from pool: {0}", e.getMessage());
                return creator.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(T obj) {
            block8: {
                try {
                    if (!(obj instanceof TextDisplay)) break block8;
                    TextDisplay display = (TextDisplay)obj;
                    if (display.isDead()) {
                        return;
                    }
                    display.text((Component)Component.empty());
                    display.setCustomNameVisible(false);
                    List<T> list = this.pool;
                    synchronized (list) {
                        if (this.pool.size() < this.maxSize) {
                            this.pool.add(obj);
                        } else {
                            display.remove();
                        }
                    }
                }
                catch (Exception e) {
                    Bukkit.getLogger().log(Level.FINE, "[nonchat] Error releasing to pool: {0}", e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            try {
                List<T> list = this.pool;
                synchronized (list) {
                    this.pool.forEach(obj -> {
                        try {
                            if (obj instanceof TextDisplay) {
                                TextDisplay display = (TextDisplay)obj;
                                display.remove();
                            }
                        }
                        catch (Exception e) {
                            Bukkit.getLogger().log(Level.FINE, "[nonchat] Error removing text display from pool: {0}", e.getMessage());
                        }
                    });
                    this.pool.clear();
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.FINE, "[nonchat] Error clearing pool: {0}", e.getMessage());
            }
        }
    }
}

