/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.core.colors;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class LRUCache<K, V> {
    private final Map<K, V> cache;
    private final int maxSize;

    public LRUCache(final int maxSize) {
        this.maxSize = maxSize;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<K, V>(maxSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return LRUCache.this.cache.size() > maxSize;
            }
        });
    }

    public V get(K key) {
        return this.cache.get(key);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }
}

