/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.items.detection;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.util.chat.filters.LinkDetector;
import com.nonxedy.nonchat.util.items.display.ItemDisplayUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemDetector {
    private static final Pattern ITEM_PATTERN = Pattern.compile("\\[item\\]", 2);

    public static Component processItemPlaceholders(Player player, String text) {
        if (text == null || text.isEmpty()) {
            return Component.text((String)text);
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin("nonchat");
        if (plugin instanceof Nonchat) {
            Nonchat nonchatPlugin = (Nonchat)plugin;
            boolean globalEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.enabled", true);
            boolean itemEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.item-enabled", true);
            if (!globalEnabled || !itemEnabled) {
                return LinkDetector.makeLinksClickable(text);
            }
        }
        TextComponent.Builder builder = Component.text().content("");
        Matcher matcher = ITEM_PATTERN.matcher(text);
        int lastEnd = 0;
        boolean foundItem = false;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                String textBefore = text.substring(lastEnd, matcher.start());
                builder.append(LinkDetector.makeLinksClickable(textBefore));
            }
            ItemStack heldItem = player.getInventory().getItemInMainHand();
            Component itemComponent = ItemDisplayUtil.createBracketedItemComponent(heldItem);
            builder.append(itemComponent);
            lastEnd = matcher.end();
            foundItem = true;
        }
        if (lastEnd < text.length()) {
            String remainingText = text.substring(lastEnd);
            builder.append(LinkDetector.makeLinksClickable(remainingText));
        }
        if (!foundItem) {
            return LinkDetector.makeLinksClickable(text);
        }
        return builder.build();
    }
}

