/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.items.localization;

import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class ItemLocalizationUtil {
    public static Component getLocalizedMaterialComponent(Material material) {
        String translationKey = ItemLocalizationUtil.getTranslationKey(material);
        return Component.translatable((String)translationKey);
    }

    public static String getLocalizedMaterialName(Material material, String language) {
        return ItemLocalizationUtil.formatMaterialName(material.name());
    }

    public static Component getLocalizedEnchantmentComponent(Enchantment enchantment) {
        String translationKey = "enchantment.minecraft." + enchantment.getKey().getKey();
        return Component.translatable((String)translationKey);
    }

    public static String getLocalizedEnchantmentName(Enchantment enchantment, String language) {
        return ItemLocalizationUtil.formatEnchantmentName(enchantment.getKey().getKey());
    }

    public static Component createTranslatableItemComponent(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return Component.translatable((String)"item.minecraft.air");
        }
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return item.getItemMeta().displayName();
        }
        String translationKey = ItemLocalizationUtil.getTranslationKey(item.getType());
        return Component.translatable((String)translationKey);
    }

    private static String getTranslationKey(Material material) {
        String materialName = material.name().toLowerCase();
        if (material.isBlock()) {
            return "block.minecraft." + materialName;
        }
        return "item.minecraft." + materialName;
    }

    private static String formatMaterialName(String materialName) {
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            if (words[i].length() <= 0) continue;
            result.append(Character.toUpperCase(words[i].charAt(0)));
            if (words[i].length() <= 1) continue;
            result.append(words[i].substring(1));
        }
        return result.toString();
    }

    private static String formatEnchantmentName(String enchantmentName) {
        String name = enchantmentName.replace('_', ' ');
        StringBuilder formattedName = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == ' ') {
                capitalizeNext = true;
                formattedName.append(c);
                continue;
            }
            if (capitalizeNext) {
                formattedName.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            formattedName.append(c);
        }
        return formattedName.toString();
    }
}

