/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.chat.channel;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.command.impl.IgnoreCommand;
import com.nonxedy.nonchat.service.ConfigService;
import com.nonxedy.nonchat.util.chat.filters.LinkDetector;
import com.nonxedy.nonchat.util.chat.formatting.HoverTextUtil;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.items.detection.ItemDetector;
import com.nonxedy.nonchat.util.items.display.ItemDisplayUtil;
import com.nonxedy.nonchat.util.special.ping.PingDetector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BaseChannel
implements Channel {
    private final String id;
    private final String displayName;
    private final String format;
    private final char character;
    private final String sendPermission;
    private final String receivePermission;
    private final int radius;
    private final String world;
    private final int cooldown;
    private final int minLength;
    private final int maxLength;
    private final HoverTextUtil hoverTextUtil;
    private boolean enabled;
    private static final Pattern mentionPattern = Pattern.compile("@(\\w+)");
    private IgnoreCommand ignoreCommand;
    private ConfigService configService;

    public BaseChannel(String id, String displayName, String format, char character, String sendPermission, String receivePermission, int radius, boolean enabled, HoverTextUtil hoverTextUtil, int cooldown, int minLength, int maxLength) {
        this(id, displayName, format, character, sendPermission, receivePermission, radius, "", enabled, hoverTextUtil, cooldown, minLength, maxLength);
    }

    public BaseChannel(String id, String displayName, String format, char character, String sendPermission, String receivePermission, int radius, String world, boolean enabled, HoverTextUtil hoverTextUtil, int cooldown, int minLength, int maxLength) {
        this.id = id;
        this.displayName = displayName;
        this.format = format;
        this.character = character;
        this.sendPermission = sendPermission;
        this.receivePermission = receivePermission;
        this.radius = radius;
        this.world = world;
        this.enabled = enabled;
        this.hoverTextUtil = hoverTextUtil;
        this.cooldown = cooldown;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public char getCharacter() {
        return this.character;
    }

    @Override
    public boolean hasTriggerCharacter() {
        return this.character != '\u0000';
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getSendPermission() {
        return this.sendPermission;
    }

    @Override
    public String getReceivePermission() {
        return this.receivePermission;
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public boolean isGlobal() {
        return this.radius == -1;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public boolean isWorldSpecific() {
        return !this.world.isEmpty();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public boolean canSend(Player player) {
        return this.sendPermission == null || this.sendPermission.isEmpty() || player.hasPermission(this.sendPermission);
    }

    @Override
    public boolean canReceive(Player player) {
        return this.receivePermission == null || this.receivePermission.isEmpty() || player.hasPermission(this.receivePermission);
    }

    @Override
    public boolean isInRange(Player sender, Player recipient) {
        if (this.isGlobal()) {
            return true;
        }
        if (this.isWorldSpecific()) {
            return sender.getWorld().getName().equals(this.world) && recipient.getWorld().getName().equals(this.world);
        }
        if (sender.getWorld() != recipient.getWorld()) {
            return false;
        }
        return sender.getLocation().distance(recipient.getLocation()) <= (double)this.radius;
    }

    @Override
    public Component formatMessage(Player player, String message) {
        String baseFormat = this.getFormat();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                baseFormat = PlaceholderAPI.setPlaceholders((Player)player, (String)baseFormat);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error processing format placeholders: {0}", e.getMessage());
            }
        }
        if (this.containsSpanningGradient(baseFormat)) {
            return this.formatMessageWithSpanningGradient(player, message, baseFormat);
        }
        String[] formatParts = baseFormat.split("\\{message\\}");
        String beforeMessage = formatParts[0];
        String afterMessage = formatParts.length > 1 ? formatParts[1] : "";
        String inheritedColor = this.extractTrailingColor(beforeMessage);
        Component beforeMessageComponent = ColorUtil.parseConfigComponent(beforeMessage);
        Component afterMessageComponent = ColorUtil.parseConfigComponent(afterMessage);
        beforeMessageComponent = this.hoverTextUtil.addHoverToComponent(beforeMessageComponent, player);
        afterMessageComponent = this.hoverTextUtil.addHoverToComponent(afterMessageComponent, player);
        Component finalMessage = beforeMessageComponent.append(this.processMessageContent(player, message, inheritedColor)).append(afterMessageComponent);
        return finalMessage;
    }

    private boolean containsSpanningGradient(String format) {
        if (format == null || format.isEmpty()) {
            return false;
        }
        Pattern gradientPattern = Pattern.compile("<gradient:[^>]+>");
        Matcher matcher = gradientPattern.matcher(format);
        while (matcher.find()) {
            String afterMessage;
            int gradientStart = matcher.start();
            int messageIndex = format.indexOf("{message}");
            if (messageIndex <= gradientStart || !(afterMessage = format.substring(messageIndex + 9)).contains("</gradient>")) continue;
            return true;
        }
        return false;
    }

    private Component formatMessageWithSpanningGradient(Player player, String message, String format) {
        String processedMessage = message;
        if (!player.hasPermission("nonchat.color")) {
            processedMessage = ColorUtil.stripAllColors(message);
        }
        String fullFormat = format.replace("{message}", processedMessage);
        Component fullComponent = ColorUtil.parseConfigComponent(fullFormat);
        return this.hoverTextUtil.addHoverToComponent(fullComponent, player);
    }

    private String extractTrailingColor(String formatPart) {
        if (formatPart == null || formatPart.isEmpty()) {
            return "";
        }
        Pattern hexPattern = Pattern.compile(".*(\u00a7#[A-Fa-f0-9]{6}|&#[A-Fa-f0-9]{6})(?:[^\u00a7&]*?)$");
        Matcher hexMatcher = hexPattern.matcher(formatPart);
        if (hexMatcher.find()) {
            return hexMatcher.group(1);
        }
        Pattern legacyPattern = Pattern.compile(".*(\u00a7[0-9a-fklmnor]|&[0-9a-fklmnor])(?:[^\u00a7&]*?)$");
        Matcher legacyMatcher = legacyPattern.matcher(formatPart);
        if (legacyMatcher.find()) {
            return legacyMatcher.group(1);
        }
        Pattern miniPattern = Pattern.compile(".*(<#[A-Fa-f0-9]{6}>|<(?:black|dark_blue|dark_green|dark_aqua|dark_red|dark_purple|gold|gray|dark_gray|blue|green|aqua|red|light_purple|yellow|white)>)(?:[^<]*?)$");
        Matcher miniMatcher = miniPattern.matcher(formatPart);
        if (miniMatcher.find()) {
            return miniMatcher.group(1);
        }
        Pattern gradientPattern = Pattern.compile(".*(<gradient:[^>]+>)(?:[^<]*?)$");
        Matcher gradientMatcher = gradientPattern.matcher(formatPart);
        if (gradientMatcher.find()) {
            return gradientMatcher.group(1);
        }
        return "";
    }

    private Component processMessageContent(Player player, String message, String inheritedColor) {
        Nonchat nonchatPlugin;
        boolean globalEnabled;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("nonchat");
        if (plugin instanceof Nonchat && !(globalEnabled = (nonchatPlugin = (Nonchat)plugin).getConfig().getBoolean("interactive-placeholders.enabled", true))) {
            return this.processMessageWithColorPermission(player, message, inheritedColor);
        }
        boolean hasItem = message.toLowerCase().contains("[item]");
        boolean hasPing = message.toLowerCase().contains("[ping]");
        if (hasItem && hasPing) {
            return this.processBothPlaceholders(player, message, inheritedColor);
        }
        if (hasItem) {
            return this.processItemPlaceholderWithColorPermission(player, message, inheritedColor);
        }
        if (hasPing) {
            return this.processPingPlaceholderWithColorPermission(player, message, inheritedColor);
        }
        return this.processMessageWithColorPermission(player, message, inheritedColor);
    }

    private Component processMessageWithColorPermission(Player player, String message, String inheritedColor) {
        Object processedMessage = message;
        if (player.hasPermission("nonchat.color") && !inheritedColor.isEmpty() && !ColorUtil.hasColorCodes(message)) {
            processedMessage = inheritedColor + message;
        }
        Component linkProcessed = LinkDetector.makeLinksClickable((String)processedMessage);
        if (!player.hasPermission("nonchat.color")) {
            Object strippedMessage = ColorUtil.stripAllColors(message);
            if (!inheritedColor.isEmpty()) {
                strippedMessage = inheritedColor + (String)strippedMessage;
            }
            return LinkDetector.makeLinksClickable((String)strippedMessage);
        }
        return linkProcessed;
    }

    private Component processItemPlaceholderWithColorPermission(Player player, String message, String inheritedColor) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("nonchat");
        boolean itemEnabled = true;
        if (plugin instanceof Nonchat) {
            Nonchat nonchatPlugin = (Nonchat)plugin;
            itemEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.item-enabled", true);
        }
        if (!itemEnabled) {
            return this.processMessageWithColorPermission(player, message, inheritedColor);
        }
        Object processedMessage = message;
        if (player.hasPermission("nonchat.color") && !inheritedColor.isEmpty() && !ColorUtil.hasColorCodes(message)) {
            processedMessage = inheritedColor + message;
        }
        if (!player.hasPermission("nonchat.color")) {
            Object messageWithoutColors = ColorUtil.stripAllColors(message);
            if (!inheritedColor.isEmpty()) {
                messageWithoutColors = inheritedColor + (String)messageWithoutColors;
            }
            return ItemDetector.processItemPlaceholders(player, (String)messageWithoutColors);
        }
        return ItemDetector.processItemPlaceholders(player, (String)processedMessage);
    }

    private Component processPingPlaceholderWithColorPermission(Player player, String message, String inheritedColor) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("nonchat");
        boolean pingEnabled = true;
        if (plugin instanceof Nonchat) {
            Nonchat nonchatPlugin = (Nonchat)plugin;
            pingEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.ping-enabled", true);
        }
        if (!pingEnabled) {
            return this.processMessageWithColorPermission(player, message, inheritedColor);
        }
        Object processedMessage = message;
        if (player.hasPermission("nonchat.color") && !inheritedColor.isEmpty() && !ColorUtil.hasColorCodes(message)) {
            processedMessage = inheritedColor + message;
        }
        if (!player.hasPermission("nonchat.color")) {
            Object messageWithoutColors = ColorUtil.stripAllColors(message);
            if (!inheritedColor.isEmpty()) {
                messageWithoutColors = inheritedColor + (String)messageWithoutColors;
            }
            return PingDetector.processPingPlaceholders(player, (String)messageWithoutColors);
        }
        return PingDetector.processPingPlaceholders(player, (String)processedMessage);
    }

    private Component processBothPlaceholders(Player player, String message, String inheritedColor) {
        Object textPart;
        boolean hasColorPermission;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("nonchat");
        boolean itemEnabled = true;
        boolean pingEnabled = true;
        if (plugin instanceof Nonchat) {
            Nonchat nonchatPlugin = (Nonchat)plugin;
            itemEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.item-enabled", true);
            pingEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.ping-enabled", true);
        }
        Object processedMessage = message;
        if (player.hasPermission("nonchat.color") && !inheritedColor.isEmpty() && !ColorUtil.hasColorCodes(message)) {
            processedMessage = inheritedColor + message;
        }
        Object object = processedMessage = (hasColorPermission = player.hasPermission("nonchat.color")) ? processedMessage : ColorUtil.stripAllColors(message);
        if (hasColorPermission || !inheritedColor.isEmpty()) {
            // empty if block
        }
        TextComponent.Builder builder = Component.text();
        String[] parts = ((String)processedMessage).split("(?i)\\[(item|ping)\\]");
        Pattern pattern = Pattern.compile("(?i)\\[(item|ping)\\]");
        Matcher matcher = pattern.matcher((CharSequence)processedMessage);
        int partIndex = 0;
        while (matcher.find()) {
            if (partIndex < parts.length && !parts[partIndex].isEmpty()) {
                textPart = parts[partIndex];
                if (!hasColorPermission && !inheritedColor.isEmpty()) {
                    textPart = inheritedColor + (String)textPart;
                }
                builder.append(LinkDetector.makeLinksClickable((String)textPart));
            }
            ++partIndex;
            String placeholder = matcher.group().toLowerCase();
            if (placeholder.equals("[item]") && itemEnabled) {
                ItemStack heldItem = player.getInventory().getItemInMainHand();
                Component itemComponent = ItemDisplayUtil.createBracketedItemComponent(heldItem);
                builder.append(itemComponent);
                continue;
            }
            if (placeholder.equals("[ping]") && pingEnabled) {
                int ping = player.getPing();
                NamedTextColor color = ping < 100 ? NamedTextColor.GREEN : (ping < 300 ? NamedTextColor.GOLD : NamedTextColor.RED);
                builder.append(Component.text((String)(ping + "ms")).color((TextColor)color));
                continue;
            }
            Object placeholderText = matcher.group();
            if (!hasColorPermission && !inheritedColor.isEmpty()) {
                placeholderText = inheritedColor + (String)placeholderText;
            }
            builder.append((Component)Component.text((String)placeholderText));
        }
        if (partIndex < parts.length && !parts[partIndex].isEmpty()) {
            textPart = parts[partIndex];
            if (!hasColorPermission && !inheritedColor.isEmpty()) {
                textPart = inheritedColor + (String)textPart;
            }
            builder.append(LinkDetector.makeLinksClickable((String)textPart));
        }
        return builder.build();
    }

    public void setIgnoreCommand(IgnoreCommand ignoreCommand) {
        this.ignoreCommand = ignoreCommand;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }
}

