/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.command.impl;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.command.impl.IgnoreCommand;
import com.nonxedy.nonchat.command.impl.SpyCommand;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.service.ChatService;
import com.nonxedy.nonchat.service.ConfigService;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.integration.external.IntegrationUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MessageCommand
implements CommandExecutor,
TabCompleter {
    private final Map<UUID, UUID> lastMessaged = new HashMap<UUID, UUID>();
    private final Nonchat plugin;
    private final PluginConfig config;
    private final PluginMessages messages;
    private final SpyCommand spyCommand;
    private final ChatService chatService;
    private IgnoreCommand ignoreCommand;

    public MessageCommand(Nonchat plugin, PluginConfig config, PluginMessages messages, SpyCommand spyCommand) {
        this.plugin = plugin;
        this.config = config;
        this.messages = messages;
        this.spyCommand = spyCommand;
        this.chatService = null;
        this.ignoreCommand = plugin.getIgnoreCommand();
    }

    public MessageCommand(ChatService chatService, ConfigService configService) {
        this.chatService = chatService;
        this.plugin = null;
        this.config = configService.getConfig();
        this.messages = configService.getMessages();
        this.spyCommand = null;
        this.ignoreCommand = null;
    }

    public Map<UUID, UUID> getLastMessaged() {
        return this.lastMessaged;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (this.plugin != null) {
            this.plugin.logCommand(command.getName(), args);
        }
        if (!this.isMessageCommand(command.getName())) {
            if (this.plugin != null) {
                this.plugin.logError("Invalid command: " + command.getName());
            }
            return false;
        }
        if (!sender.hasPermission("nonchat.message")) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            if (this.plugin != null) {
                this.plugin.logError("Player " + sender.getName() + " tried to use the message command without permission.");
            }
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-usage-message")));
            if (this.plugin != null) {
                this.plugin.logError("Player " + sender.getName() + " tried to use the message command with invalid arguments.");
            }
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("player-not-found")));
            if (this.plugin != null) {
                this.plugin.logError("Player " + sender.getName() + " tried to message a player that is not online.");
            }
            return true;
        }
        if (this.isIgnored(sender, target)) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("ignored-by-target")));
            if (this.plugin != null) {
                this.plugin.logError("Player " + sender.getName() + " tried to message a player that has ignored them.");
            }
            return true;
        }
        if (sender instanceof Player && this.isIgnoringTarget((Player)sender, target)) {
            sender.sendMessage(ColorUtil.parseComponent(this.messages.getString("you-are-ignoring-player").replace("%player%", target.getName())));
            if (this.plugin != null) {
                this.plugin.logError("Player " + sender.getName() + " tried to message a player they are ignoring.");
            }
            return true;
        }
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        if (this.chatService != null) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.chatService.handlePrivateMessage(player, target, message);
            } else {
                this.sendPrivateMessage(sender, target, message);
            }
        } else {
            this.sendPrivateMessage(sender, target, message);
        }
        return true;
    }

    private boolean isMessageCommand(String commandName) {
        return commandName.equalsIgnoreCase("message") || commandName.equalsIgnoreCase("msg") || commandName.equalsIgnoreCase("tell") || commandName.equalsIgnoreCase("w") || commandName.equalsIgnoreCase("m") || commandName.equalsIgnoreCase("whisper");
    }

    private boolean isIgnored(CommandSender sender, Player target) {
        if (!(sender instanceof Player)) {
            return false;
        }
        IgnoreCommand ignoreCommand = this.getIgnoreCommand();
        if (ignoreCommand != null) {
            return ignoreCommand.isIgnoring(target, (Player)sender);
        }
        return false;
    }

    private boolean isIgnoringTarget(Player sender, Player target) {
        IgnoreCommand ignoreCommand = this.getIgnoreCommand();
        if (ignoreCommand != null) {
            return ignoreCommand.isIgnoring(sender, target);
        }
        return false;
    }

    private IgnoreCommand getIgnoreCommand() {
        if (this.ignoreCommand != null) {
            return this.ignoreCommand;
        }
        if (this.plugin != null) {
            return this.plugin.getIgnoreCommand();
        }
        return null;
    }

    private void sendPrivateMessage(CommandSender sender, Player target, String message) {
        Player player;
        String processedMessage = sender instanceof Player && !(player = (Player)sender).hasPermission("nonchat.color") ? ColorUtil.stripAllColors(message) : message;
        String format = this.config.getPrivateChatFormat();
        String senderName = sender instanceof Player ? sender.getName() : "Console";
        Component senderMessage = ColorUtil.parseComponent(format.replace("{sender}", senderName).replace("{target}", target.getName()).replace("{message}", processedMessage));
        sender.sendMessage(senderMessage);
        if (this.plugin != null) {
            this.plugin.logResponse("Message sent to " + sender.getName());
        }
        String targetYouText = this.config.getPrivateChatTargetYou();
        if (target != null) {
            targetYouText = IntegrationUtil.processPlaceholders(target, targetYouText);
        }
        Component targetMessage = ColorUtil.parseComponent(format.replace("{sender}", senderName).replace("{target}", targetYouText).replace("{message}", processedMessage));
        target.sendMessage(targetMessage);
        if (this.plugin != null) {
            this.plugin.logResponse("Message sent to " + target.getName());
        }
        if (this.spyCommand != null && sender instanceof Player) {
            this.spyCommand.onPrivateMessage((Player)sender, target, (Component)Component.text((String)processedMessage));
            if (this.plugin != null) {
                this.plugin.logResponse("Message sent to spy players");
            }
        }
        if (sender instanceof Player) {
            Player player2 = (Player)sender;
            this.plugin.getMessageManager().getLastMessageSender().put(target.getUniqueId(), player2.getUniqueId());
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("nonchat.message")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> !name.equals(sender.getName())).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            List<String> suggestions = Arrays.asList("message");
            return suggestions.stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void setIgnoreCommand(IgnoreCommand ignoreCommand) {
        this.ignoreCommand = ignoreCommand;
    }
}

